/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.msg.ConnectMessage;
import ca.nanometrics.msg.RequestPending;
import ca.nanometrics.msg.TerminateMessage;
import ca.nanometrics.packet.Packable;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.util.Log;
import ca.nanometrics.util.Runner;
import java.io.IOException;
import java.io.InterruptedIOException;

public class DSRequestBroker
extends Runner {
    static final byte NORMAL_SHUTDOWN = 1;
    static final byte ERROR_SHUTDOWN = 2;
    static final byte TIMEOUT_SHUTDOWN = 3;
    private DSConnection connection;
    private DSSubscription subscription;
    private MsgHandler cmdHandler;

    public DSRequestBroker(DSConnection dsConnection, DSSubscription dsSubscription, MsgHandler msgHandler) {
        this.connection = dsConnection;
        this.subscription = dsSubscription;
        this.cmdHandler = msgHandler;
        this.setDaemon(true);
    }

    private void shutdown(byte type, String reason) {
        if (reason != null) {
            this.connection.send(new TerminateMessage(type, reason));
        }
        this.connection.close();
        this.stayAlive = false;
    }

    public void stop(boolean doJoin) {
        this.shutdown((byte)2, "NaqsServer has stopped.");
        super.stop(doJoin);
    }

    private void refuseConnection(String reason) {
        Log.report(this, 21, 3, "Connection refused from " + this.connection + " (" + reason + ")");
        this.shutdown((byte)2, null);
    }

    public void run() {
        boolean connected = false;
        try {
            while (this.stayAlive) {
                Packable p = this.connection.receive();
                if (p instanceof ConnectMessage) {
                    connected = true;
                    this.subscription.sendChannelList();
                    continue;
                }
                if (!connected) {
                    this.refuseConnection("Invalid Connect Message");
                    continue;
                }
                if (p instanceof RequestPending) continue;
                if (p instanceof TerminateMessage) {
                    Log.report(this, 1, 2, "Client terminated connection: " + this.connection);
                    this.shutdown((byte)1, null);
                    continue;
                }
                this.connection.setTimeout(0);
                this.subscription.processRequest(p);
                this.cmdHandler.handleMessage(p, this.connection);
            }
        }
        catch (InterruptedIOException receiveTimeout) {
            Log.report(this, 2, 2, "Request timeout occured for " + this.connection);
            this.shutdown((byte)3, "No request made: connection timed out.");
        }
        catch (InvalidInputException inputException) {
            Log.report(this, 3, 2, "Invalid request format from " + this.connection);
            this.shutdown((byte)2, "Invalid request format.");
        }
        catch (IOException recvException) {
            Log.report(this, 4, 2, "Lost connection to " + this.connection + ".");
            this.shutdown((byte)1, null);
        }
    }
}

