/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.naqs.stndb.StationDatabase;
import ca.nanometrics.net.CallbackServer;
import ca.nanometrics.packet.EventHandler;
import ca.nanometrics.packet.NmxPacket;
import ca.nanometrics.packet.NmxPacketHandler;
import ca.nanometrics.packet.TriggerHandler;
import ca.nanometrics.util.Log;
import ca.nanometrics.util.NmxDateFormat;
import ca.nanometrics.util.Runner;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;

public class DSServer
extends Runner
implements NmxPacketHandler {
    private static final int WDG_LOOP_TIMEOUT = 60;
    private StationDatabase stndb;
    private NmxBufferTable nmxBufferTable;
    private NmxPacketSource retxSource;
    private MsgHandler cmdHandler;
    private SubscriberList subscribers = new SubscriberList();
    private int port;
    private int maxConn;
    private boolean callback = false;
    private ServerSocket server;
    private String lastReport;
    private int connectionCount;
    private NmxDateFormat dateFormat = new NmxDateFormat("yyyy/MM/dd_HH:mm:ss");

    public DSServer(DatastreamConfig config, StationDatabase stnDatabase, NmxPacketSource nmxPacketSource, MsgHandler msgHandler) {
        this.port = config.getPort();
        this.maxConn = config.getMaxConnections();
        this.callback = config.useCallbackSocket();
        this.stndb = stnDatabase;
        this.retxSource = nmxPacketSource;
        this.cmdHandler = msgHandler;
        this.nmxBufferTable = new NmxBufferTable(config.getDataBufferLength());
        this.setWdgTimeout(60);
        this.resetStatus();
    }

    public void put(NmxPacket packet) {
        this.nmxBufferTable.put(packet);
        this.subscribers.put(packet);
    }

    public NmxPacketHandler getNmxPacketHandler() {
        return this;
    }

    public TriggerHandler getTriggerHandler() {
        return this.subscribers;
    }

    public EventHandler getEventHandler() {
        return this.subscribers;
    }

    protected void open() {
        this.setPriority(8);
        try {
            this.server = this.callback ? new CallbackServer(this.port, 5, 0) : new ServerSocket(this.port, 5);
            this.server.setSoTimeout(3000);
            Log.report(this, 1, 2, "starting with priority " + this.getPriority());
            Log.report(this, 4, 2, "listening on port " + this.server.getLocalPort());
        }
        catch (IOException ioe) {
            this.stayAlive = false;
            Log.report(this, 11, 5, "Cannot start service: " + ioe.getMessage());
        }
    }

    protected DSSubscriber createSubscriber(Socket socket) {
        try {
            return new DSSubscriber(socket, this.stndb, this.nmxBufferTable, this.retxSource, this.cmdHandler);
        }
        catch (Exception any) {
            return null;
        }
    }

    protected void handleConnection(Socket socket) {
        DSSubscriber subscriber = this.createSubscriber(socket);
        if (subscriber != null) {
            subscriber.start();
            this.subscribers.add(subscriber);
            ++this.connectionCount;
            Log.report(this, 0, 2, "Got connection (" + this.subscribers.size() + ") from " + subscriber);
        } else {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected void acceptConnection() {
        try {
            Socket socket = this.server.accept();
            this.handleConnection(socket);
        }
        catch (InterruptedIOException iioe) {
            this.sleep(1000L);
        }
        catch (IOException ioe) {
            Log.report(this, 26, 4, "Server error: " + ioe.getMessage());
        }
    }

    protected void close() {
        try {
            if (this.server != null) {
                this.server.close();
            }
        }
        catch (IOException ioe) {
            Log.report(this, 20, 4, "Unable to close server socket.");
        }
        this.subscribers.closeAll();
    }

    public void run() {
        this.setWdgTimeout(60);
        this.open();
        while (this.stayAlive) {
            this.setWdgTimeout(60);
            this.subscribers.removeDeadSubscribers();
            if (this.subscribers.size() < this.maxConn) {
                this.acceptConnection();
                continue;
            }
            this.sleep(1000L);
        }
        this.close();
        Log.report(this, 18, 2, "Stopped.");
    }

    protected synchronized void reportStatus() {
        Log.report(this, 0, 2, "New connections since " + this.lastReport + ": " + this.connectionCount);
        Log.report(this, 0, 2, "Current number of connections: " + this.subscribers.size());
        this.subscribers.list();
    }

    protected void resetStatus() {
        this.lastReport = this.dateFormat.format(System.currentTimeMillis() / 1000L);
        this.connectionCount = 0;
    }

    public synchronized void reportSummary() {
        this.reportStatus();
        this.resetStatus();
    }

    public void reportStatus(String hint) {
        if (hint.equals("ALL") || hint.equals("SUMMARY") || hint.equals("CONNECTIONS")) {
            this.reportStatus();
        }
    }
}

