/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.acq.fir.FirTable;
import ca.nanometrics.msg.CalibrationInfoRequest;
import ca.nanometrics.msg.CalibrationInfoTable;
import ca.nanometrics.msg.ChannelAddRequest;
import ca.nanometrics.msg.ChannelList;
import ca.nanometrics.msg.ChannelRemoveRequest;
import ca.nanometrics.msg.ChannelRequest;
import ca.nanometrics.msg.DataAddRequest;
import ca.nanometrics.msg.EventAddRequest;
import ca.nanometrics.msg.EventRemoveRequest;
import ca.nanometrics.msg.NmxpSequenceRequest;
import ca.nanometrics.msg.TriggerAddRequest;
import ca.nanometrics.msg.TriggerRemoveRequest;
import ca.nanometrics.naqs.stndb.StationDatabase;
import ca.nanometrics.packet.EventHandler;
import ca.nanometrics.packet.EventPacket;
import ca.nanometrics.packet.NmxPacket;
import ca.nanometrics.packet.NmxPacketHandler;
import ca.nanometrics.packet.Packable;
import ca.nanometrics.packet.TriggerHandler;
import ca.nanometrics.packet.TriggerPacket;
import ca.nanometrics.util.Log;
import java.util.Hashtable;
import java.util.Iterator;

public class DSSubscription
implements NmxPacketHandler,
TriggerHandler,
EventHandler {
    private static FirTable firTable = new FirTable();
    private Hashtable table = new Hashtable();
    private DSConnection connection;
    private StationDatabase stndb;
    private NmxBufferTable bufferTable;
    private NmxPacketSource retxSource;
    private NmxPacketHandler retxTarget;
    private boolean triggersSubscribed = false;
    private boolean eventsSubscribed = false;

    public DSSubscription(DSConnection dsConnection, StationDatabase stnDatabase, NmxBufferTable nmxBufferTable, NmxPacketSource retxPacketSource, NmxPacketHandler retxPacketTarget) {
        this.connection = dsConnection;
        this.stndb = stnDatabase;
        this.bufferTable = nmxBufferTable;
        this.retxSource = retxPacketSource;
        this.retxTarget = retxPacketTarget;
    }

    private void setTriggersSubscribed(boolean subscribed) {
        if (subscribed && !this.triggersSubscribed) {
            Log.report(this, 6, 1, "subscribing to triggers on " + this.connection);
        } else if (this.triggersSubscribed && !subscribed) {
            Log.report(this, 7, 1, "unsubscribing triggers on " + this.connection);
        }
        this.triggersSubscribed = subscribed;
    }

    private void setEventsSubscribed(boolean subscribed) {
        if (subscribed && !this.eventsSubscribed) {
            Log.report(this, 8, 1, "subscribing to events on " + this.connection);
        } else if (this.eventsSubscribed && !subscribed) {
            Log.report(this, 9, 1, "unsubscribing events on " + this.connection);
        }
        this.eventsSubscribed = subscribed;
    }

    public boolean wantsTriggers() {
        return this.triggersSubscribed;
    }

    public boolean wantsEvents() {
        return this.eventsSubscribed;
    }

    private Integer keyOf(int key) {
        return new Integer(key);
    }

    private void addChannel(int key, DSChannel channel) {
        if (channel != null) {
            this.table.put(this.keyOf(key), channel);
        }
    }

    private void removeChannel(int key) {
        this.table.remove(this.keyOf(key));
    }

    public boolean contains(int key) {
        return this.table.containsKey(this.keyOf(key));
    }

    public int size() {
        return this.table.size();
    }

    private DSChannel getChannel(int key) {
        return (DSChannel)this.table.get(this.keyOf(key));
    }

    public void put(NmxPacket packet) {
        DSChannel channel = this.getChannel(packet.getKey());
        if (channel != null) {
            channel.put(packet);
        }
    }

    public void put(TriggerPacket packet) {
        if (this.triggersSubscribed) {
            this.connection.send(packet);
        }
    }

    public void put(EventPacket packet) {
        if (this.eventsSubscribed) {
            this.connection.send(packet);
        }
    }

    public synchronized void tick() {
        Iterator iter = this.table.values().iterator();
        while (iter.hasNext()) {
            DSChannel channel = (DSChannel)iter.next();
            channel.tick();
        }
    }

    public synchronized void allowRetxRequest(int maxPackets) {
        Range range;
        int maxUrgency = 0;
        DSChannel retxChannel = null;
        Iterator iter = this.table.values().iterator();
        while (iter.hasNext()) {
            DSChannel channel = (DSChannel)iter.next();
            int urgency = channel.getRetxCount();
            if (urgency <= maxUrgency) continue;
            maxUrgency = urgency;
            retxChannel = channel;
        }
        if (retxChannel != null && (range = retxChannel.getRequestedRange(maxPackets)) != null) {
            this.retxSource.requestPackets(retxChannel.getKey(), range.getStart(), range.getEnd(), this.retxTarget);
        }
    }

    public void sendChannelList() {
        Log.report(this, 1, 1, "sending channel list to " + this.connection);
        ChannelList chnlList = this.stndb.getChannelList();
        this.connection.send(chnlList);
        this.connection.flush();
    }

    private void sendCalibrationInfo() {
        Log.report(this, 2, 1, "sending cal info to " + this.connection);
        CalibrationInfoTable info = this.stndb.getCalibrationTable();
        this.connection.send(info);
        this.connection.flush();
    }

    private int[] getRequestedKeys(ChannelRequest request) {
        if (request.getChannelCount() > 0) {
            return request.getChannels();
        }
        ChannelList clist = this.stndb.getChannelList();
        return clist.getChannelKeys(request.getNmxpType());
    }

    private DSChannel makeNmxpChannel(int key, int maxDelay) {
        if (maxDelay < 0) {
            return new RawNmxpChannel(key, this.connection);
        }
        return new StcNmxpChannel(key, this.connection, maxDelay);
    }

    private void addNmxpChannels(ChannelAddRequest request) {
        int[] keys = this.getRequestedKeys(request);
        int numkeys = keys.length;
        int maxDelay = request.getMaxDelay();
        boolean wantsBuffers = request.wantsBuffers();
        int ix = 0;
        while (ix < numkeys) {
            int key = keys[ix];
            DSChannel chan = this.getChannel(key);
            DSChannel newChan = this.makeNmxpChannel(key, maxDelay);
            if (!newChan.equals(chan)) {
                this.addChannel(key, newChan);
                if (wantsBuffers) {
                    this.bufferTable.sendTo(this.retxTarget, key);
                }
            }
            ++ix;
        }
        Log.report(this, 3, 1, "added channels, total " + this.size() + " on " + this.connection);
    }

    private void addDataChannels(DataAddRequest request) {
        int outputType = request.getOutputType();
        if (outputType < 0) {
            this.addNmxpChannels(request);
        } else {
            ChannelList clist = this.stndb.getChannelList();
            int[] keys = this.getRequestedKeys(request);
            int numkeys = keys.length;
            int maxDelay = request.getMaxDelay();
            boolean wantsBuffers = request.wantsBuffers();
            int ix = 0;
            while (ix < numkeys) {
                DSChannel chan;
                DecompChannel newChan;
                int key = keys[ix];
                String channelName = clist.getNameOf(key);
                if (channelName != null && !((DSChannel)(newChan = new DecompChannel(key, channelName, this.connection, maxDelay, outputType, firTable))).equals(chan = this.getChannel(key))) {
                    this.addChannel(key, newChan);
                    if (wantsBuffers) {
                        this.bufferTable.sendTo(this.retxTarget, key);
                    }
                }
                ++ix;
            }
            Log.report(this, 4, 1, "added channels, total " + this.size() + " on " + this.connection);
        }
    }

    private void removeChannels(ChannelRequest request) {
        int[] keys = this.getRequestedKeys(request);
        int numkeys = keys.length;
        int ix = 0;
        while (ix < numkeys) {
            this.removeChannel(keys[ix]);
            ++ix;
        }
        Log.report(this, 5, 1, "unsubscribed channels, total " + this.size() + " on " + this.connection);
    }

    private void processChannelRequest(ChannelRequest request) {
        if (request instanceof DataAddRequest) {
            this.addDataChannels((DataAddRequest)request);
        } else if (request instanceof ChannelAddRequest) {
            this.addNmxpChannels((ChannelAddRequest)request);
        } else if (request instanceof ChannelRemoveRequest) {
            this.removeChannels(request);
        } else if (request instanceof TriggerAddRequest) {
            this.setTriggersSubscribed(true);
        } else if (request instanceof TriggerRemoveRequest) {
            this.setTriggersSubscribed(false);
        } else if (request instanceof EventAddRequest) {
            this.setEventsSubscribed(true);
        } else if (request instanceof EventRemoveRequest) {
            this.setEventsSubscribed(false);
        }
    }

    private void processRetxRequest(NmxpSequenceRequest request) {
        DSChannel channel = this.getChannel(request.getKey());
        if (channel != null) {
            channel.addRequest(request.getFirst(), request.getLast());
        }
    }

    public synchronized void processRequest(Packable pkt) {
        if (pkt instanceof ChannelRequest) {
            this.processChannelRequest((ChannelRequest)pkt);
        } else if (pkt instanceof CalibrationInfoRequest) {
            this.sendCalibrationInfo();
        } else if (pkt instanceof NmxpSequenceRequest) {
            this.processRetxRequest((NmxpSequenceRequest)pkt);
        }
    }

    public String toString() {
        return this.connection.toString();
    }
}

