/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.naqs.config.BoolEnum;
import ca.nanometrics.naqs.config.BoolParam;
import ca.nanometrics.naqs.config.IntParam;
import ca.nanometrics.naqs.config.IntRange;
import ca.nanometrics.naqs.config.SerialInStream;
import ca.nanometrics.naqs.config.SerialOutStream;
import ca.nanometrics.naqs.config.Serialisable;
import ca.nanometrics.naqs.config.SerialiseException;
import ca.nanometrics.naqs.config.StringParam;
import ca.nanometrics.naqs.config.StringRange;
import ca.nanometrics.naqs.config.UpdateException;
import ca.nanometrics.naqs.config.UpdateMode;
import ca.nanometrics.naqs.config.UpdateResult;
import ca.nanometrics.util.SimpleParser;
import java.io.IOException;

public class DatastreamConfig
implements Serialisable {
    static final int STREAM_PORT = 28000;
    private IntRange portRange = new IntRange(10, Short.MAX_VALUE);
    private StringRange namelen = new StringRange(3, 128);
    private IntRange connRange = new IntRange(0, 20);
    private BoolEnum socketTypes = new BoolEnum("Callback", "Direct");
    private IntRange bufferRange = new IntRange(0, 100);
    private IntParam port = new IntParam("Port", 28000, 18, this.portRange);
    private StringParam password = new StringParam("ConnPW", "nmx", 18, this.namelen);
    private IntParam maxConn = new IntParam("MaxConn", 5, 18, this.connRange);
    private BoolParam callbackSocket = new BoolParam("SocketType", false, 18, this.socketTypes);
    private IntParam dataBufferLength = new IntParam("DataBufferLength", 0, 18, this.bufferRange);
    private IntParam sohBufferLength = new IntParam("SohBufferLength", 0, 18, this.bufferRange);

    public void update(DatastreamConfig newConfig, UpdateMode mode, UpdateResult result) {
        try {
            this.port.putValue(newConfig.getPort(), mode);
        }
        catch (UpdateException ue) {
            result.postException(this, ue);
        }
        try {
            this.password.putValue(newConfig.getPassword(), mode);
        }
        catch (UpdateException ue) {
            result.postException(this, ue);
        }
        try {
            this.maxConn.putValue(newConfig.getMaxConnections(), mode);
        }
        catch (UpdateException ue) {
            result.postException(this, ue);
        }
        try {
            this.callbackSocket.putValue(newConfig.useCallbackSocket(), mode);
        }
        catch (UpdateException ue) {
            result.postException(this, ue);
        }
        try {
            this.dataBufferLength.putValue(newConfig.getDataBufferLength(), mode);
        }
        catch (UpdateException ue) {
            result.postException(this, ue);
        }
        try {
            this.sohBufferLength.putValue(newConfig.getSohBufferLength(), mode);
        }
        catch (UpdateException ue) {
            result.postException(this, ue);
        }
    }

    public int getPort() {
        return this.port.getValue();
    }

    public String getPassword() {
        return this.password.getValue();
    }

    public int getMaxConnections() {
        return this.maxConn.getValue();
    }

    public boolean useCallbackSocket() {
        return this.callbackSocket.getValue();
    }

    public int getSohBufferLength() {
        return this.sohBufferLength.getValue();
    }

    public int getDataBufferLength() {
        return this.dataBufferLength.getValue();
    }

    public void setPort(int portVal) {
        this.port.putValue(portVal);
    }

    public void setPassword(String name) {
        this.password.putValue(name);
    }

    public void setMaxConnections(int connVal) {
        this.maxConn.putValue(connVal);
    }

    public void setCallbackSocket(boolean b) {
        this.callbackSocket.putValue(b);
    }

    public void setSocketType(String s) {
        this.callbackSocket.putValue(s);
    }

    public void setSohBufferLength(int len) {
        this.sohBufferLength.putValue(len);
    }

    public void setDataBufferLength(int len) {
        this.dataBufferLength.putValue(len);
    }

    public void saveGuts(SerialOutStream strm) throws SerialiseException {
        strm.serialiseObject(this.portRange);
        strm.serialiseObject(this.namelen);
        strm.serialiseObject(this.connRange);
        strm.serialiseObject(this.socketTypes);
        this.port.saveGuts(strm);
        this.password.saveGuts(strm);
        this.maxConn.saveGuts(strm);
        this.callbackSocket.saveGuts(strm);
        strm.serialiseObject(this.bufferRange);
        this.dataBufferLength.saveGuts(strm);
        this.sohBufferLength.saveGuts(strm);
    }

    public void restoreGuts(SerialInStream strm) throws SerialiseException {
        strm.deserialiseObject(this.portRange);
        strm.deserialiseObject(this.namelen);
        strm.deserialiseObject(this.connRange);
        strm.deserialiseObject(this.socketTypes);
        this.port.restoreGuts(strm);
        this.password.restoreGuts(strm);
        this.maxConn.restoreGuts(strm);
        this.callbackSocket.restoreGuts(strm);
        strm.deserialiseObject(this.bufferRange);
        this.dataBufferLength.restoreGuts(strm);
        this.sohBufferLength.restoreGuts(strm);
    }

    public void load(SimpleParser input) throws IOException {
        if (input.isNextLineHeader("ConnectionManager")) {
            input.getHeader("ConnectionManager");
            this.setPort(input.readInt("Port"));
            this.setPassword(input.readString("Password"));
            this.setMaxConnections(input.readInt("MaxConnections"));
            this.setSocketType(input.readString("SocketType"));
            input.getHeader("StreamManager");
            this.setDataBufferLength(input.readInt("DataBufferLength"));
            this.setSohBufferLength(input.readInt("SohBufferLength"));
        } else {
            input.getHeader("Datastream");
            this.setPort(input.readInt("Port"));
            this.setPassword(input.readString("Password"));
            this.setMaxConnections(input.readInt("MaxConnections"));
            this.setSocketType(input.readString("SocketType"));
            this.setDataBufferLength(input.readInt("DataBufferLength"));
        }
    }
}

