/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.acq.fir.FilterException;
import ca.nanometrics.acq.fir.FirCoeffs;
import ca.nanometrics.acq.fir.FirStage;
import ca.nanometrics.acq.fir.FirTable;
import ca.nanometrics.packet.CompletionBuffer;
import ca.nanometrics.packet.DataPacket;
import ca.nanometrics.packet.DecompDataHandler;
import ca.nanometrics.packet.NmxPacket;
import ca.nanometrics.packet.NmxPacketHandler;
import ca.nanometrics.util.Log;

public class DecompChannel
extends DSChannel {
    private static final int PKTLEN_SEC = 1;
    private String name;
    private int maxDelay;
    private int inputRate = -1;
    private int outputRate;
    private CompletionBuffer handler;
    private DSConnection connection;
    private FirTable firTable;

    public DecompChannel(int channelKey, String channelName, DSConnection destination, int maxDelaySec, int outputSampleRate, FirTable theFirTable) {
        super(channelKey);
        this.name = channelName;
        this.connection = destination;
        this.maxDelay = Math.max(maxDelaySec, 0);
        this.outputRate = Math.max(outputSampleRate, 0);
        this.firTable = theFirTable;
        this.handler = null;
    }

    public boolean equals(Object obj) {
        DecompChannel other;
        return obj instanceof DecompChannel && (other = (DecompChannel)obj).getKey() == this.getKey() && other.maxDelay == this.maxDelay && other.outputRate == this.outputRate;
    }

    public void put(NmxPacket packet) {
        if (packet instanceof DataPacket && packet.getKey() == this.getKey()) {
            DataPacket dp = (DataPacket)packet;
            int packetRate = dp.getSampleRate();
            if (this.handler == null || packetRate != this.inputRate) {
                this.resetFilters(packetRate);
            }
            this.handler.put(packet);
        }
    }

    private void resetFilters(int packetRate) {
        if (this.inputRate > 0) {
            Log.report(this, 1, 1, String.valueOf(this.name) + ": sample rate changed.");
        }
        this.inputRate = packetRate;
        DecompDataHandler nextHandler = null;
        if (this.outputRate > 0) {
            try {
                FirCoeffs theFilter = this.firTable.getFirCoeffs(this.inputRate, this.outputRate);
                int numStages = theFilter.getNumStages();
                int stageInputRate = this.outputRate;
                nextHandler = this.connection;
                int i = numStages - 1;
                while (i >= 0) {
                    FirStage theStage = theFilter.getStage(i);
                    nextHandler = new NaqsFirFilter(this.getKey(), nextHandler, theStage.getStageCoeffs(), theStage.getDecimation(), 1, stageInputRate *= theStage.getDecimation());
                    --i;
                }
            }
            catch (FilterException any) {
                nextHandler = null;
                Log.report(this, 1, 3, String.valueOf(this.name) + " cannot be decimated from " + this.inputRate + " to " + this.outputRate + " samples/sec.");
            }
        }
        if (nextHandler == null) {
            try {
                double[] coeffs = new double[]{1.0};
                nextHandler = new NaqsFirFilter(this.getKey(), this.connection, coeffs, 1, 1, this.inputRate);
            }
            catch (FilterException any) {
                nextHandler = this.connection;
            }
        }
        this.handler = new CompletionBuffer(this.getKey(), this.maxDelay, (NmxPacketHandler)((Object)nextHandler));
    }

    public void tick() {
        if (this.handler != null) {
            this.handler.tick();
        }
    }
}

