/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.naqs.config.UpdateMode;
import ca.nanometrics.naqs.config.UpdateResult;
import ca.nanometrics.naqs.stndb.StaLtaDetectorConfig;
import ca.nanometrics.naqs.stndb.StationDatabase;
import ca.nanometrics.packet.DataPacket;
import ca.nanometrics.packet.NmxPacket;
import ca.nanometrics.packet.NmxPacketHandler;
import ca.nanometrics.packet.TriggerDistributor;
import ca.nanometrics.packet.TriggerHandler;
import ca.nanometrics.util.BufferedConsumer;
import ca.nanometrics.util.Log;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;

public class DetectionManager
extends BufferedConsumer
implements NmxPacketHandler {
    private DetectionManagerConfig cfg;
    private StationDatabase stndb;
    private Vector trigConfigs;
    private Vector detectors;
    private TriggerDistributor distributor;
    private DetectorStatus[] reporters = new DetectorStatus[0];

    public DetectionManager(DetectionManagerConfig config, StationDatabase database) {
        super("DetectionManager", 1000);
        this.cfg = config;
        this.stndb = database;
        this.distributor = new TriggerDistributor();
    }

    public void update(DetectionManagerConfig newConfig, UpdateMode mode, UpdateResult result) {
    }

    protected void open() {
        this.setPriority(10);
        Log.report(this, 5, 2, "starting with priority " + this.getPriority());
        this.trigConfigs = this.stndb.getTriggers();
        this.detectors = new Vector();
        TreeMap<String, DetectorStatus> map = new TreeMap<String, DetectorStatus>();
        Enumeration e = this.trigConfigs.elements();
        while (e.hasMoreElements()) {
            StaLtaDetectorConfig tcfg = (StaLtaDetectorConfig)e.nextElement();
            String channelName = String.valueOf(tcfg.getDottedName()) + "-" + tcfg.getTriggerType();
            DetectorStatus stat = new DetectorStatus(channelName, this.distributor);
            this.detectors.addElement(new BufferedStaLtaDetector(tcfg, stat));
            map.put(channelName.toUpperCase(), stat);
        }
        Log.report(this, 6, 2, "created " + this.detectors.size() + " detectors.");
        this.reporters = new DetectorStatus[map.size()];
        int ix = 0;
        Set keys = map.keySet();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            String channelName = (String)it.next();
            this.reporters[ix++] = (DetectorStatus)map.get(channelName);
        }
    }

    protected void close() {
        Log.report(this, 7, 2, "closing all detectors...");
        this.trigConfigs.removeAllElements();
        this.detectors.removeAllElements();
    }

    protected void process(Object obj) {
        DataPacket packet = (DataPacket)obj;
        Enumeration e = this.detectors.elements();
        while (e.hasMoreElements()) {
            BufferedDetector trig = (BufferedDetector)e.nextElement();
            trig.put(packet);
        }
    }

    protected void tick() {
        Enumeration e = this.detectors.elements();
        while (e.hasMoreElements()) {
            BufferedDetector trig = (BufferedDetector)e.nextElement();
            trig.tick();
        }
    }

    public void put(NmxPacket packet) {
        if (packet instanceof DataPacket) {
            this.append(packet);
        }
    }

    public void addTriggerSubscriber(TriggerHandler subscriber) {
        this.distributor.addSubscriber(subscriber);
    }

    public void removeTriggerSubscriber(TriggerHandler subscriber) {
        this.distributor.removeSubscriber(subscriber);
    }

    public synchronized void reportStatus(String hint) {
        int ix = 0;
        int nx = this.reporters.length;
        while (ix < nx) {
            DetectorStatus reporter = this.reporters[ix];
            String channelName = reporter.getChannelName();
            if (hint.equals("ALL") || hint.equals("TRIGGERS") || channelName.startsWith(hint) || channelName.endsWith(hint)) {
                reporter.reportStatus();
            }
            ++ix;
        }
    }

    public synchronized void reportSummary() {
        int ix = 0;
        int nx = this.reporters.length;
        while (ix < nx) {
            DetectorStatus reporter = this.reporters[ix];
            reporter.reportSummary();
            ++ix;
        }
    }
}

