/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.packet.StaLtaTrigger;
import ca.nanometrics.packet.TriggerHandler;
import ca.nanometrics.packet.TriggerPacket;
import ca.nanometrics.util.Log;
import ca.nanometrics.util.NmxDateFormat;

public class DetectorStatus
implements TriggerHandler {
    private String channelName;
    private TriggerHandler handler;
    private String lastTrigTime = null;
    private int trigCount;
    private NmxDateFormat dateFormat = new NmxDateFormat("yyyy/MM/dd_HH:mm:ss");

    public DetectorStatus(String name, TriggerHandler theHandler) {
        this.channelName = name;
        this.handler = theHandler;
        this.resetStatus();
    }

    public String getChannelName() {
        return this.channelName;
    }

    public synchronized void reportStatus() {
        if (this.lastTrigTime != null) {
            Log.report(this.channelName, 0, 2, "Trigs: " + this.trigCount + ", last: " + this.lastTrigTime);
        } else {
            Log.report(this.channelName, 0, 2, "Trigger count: " + this.trigCount);
        }
    }

    protected void resetStatus() {
        this.trigCount = 0;
    }

    public synchronized void reportSummary() {
        this.reportStatus();
        this.resetStatus();
    }

    public void put(TriggerPacket pkt) {
        try {
            StaLtaTrigger trig = (StaLtaTrigger)pkt;
            if (trig.getPhase() == 0) {
                this.lastTrigTime = this.dateFormat.format(trig.getStartTime());
                ++this.trigCount;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        this.handler.put(pkt);
    }
}

