/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.packet.EventPacket;
import ca.nanometrics.packet.StaLtaTrigger;
import ca.nanometrics.util.Log;
import ca.nanometrics.util.NmxDateFormat;
import java.util.Enumeration;
import java.util.Vector;

public class Event {
    public static final int ON = 0;
    public static final int E1 = 1;
    public static final int FINAL = 2;
    public static final int EXPIRED = 3;
    private int triggerType;
    private int coincWindow;
    private int maxDuration;
    private int maxTrigDelay;
    private int eventState;
    private double startTime;
    private double endTime;
    private double lastStart;
    private Vector triggers;
    private NmxDateFormat format;

    public Event(TriggerInfo[] inputTrigs, int detectorType, int windowSecs, int maxDurSecs, int maxDelaySecs) {
        this.triggerType = detectorType;
        this.coincWindow = windowSecs;
        this.maxDuration = maxDurSecs;
        this.maxTrigDelay = maxDelaySecs;
        this.startTime = inputTrigs[0].getStartTime();
        this.endTime = 0.0;
        this.triggers = new Vector(inputTrigs.length, 3);
        int i = 0;
        while (i < inputTrigs.length) {
            if (this.triggers.indexOf(inputTrigs[i]) < 0) {
                this.triggers.addElement(inputTrigs[i]);
            }
            ++i;
        }
        this.eventState = 0;
        this.lastStart = ((TriggerInfo)this.triggers.lastElement()).getStartTime();
        this.format = new NmxDateFormat("HH:mm:ss.SSS");
    }

    private boolean contains(TriggerInfo info) {
        Enumeration e = this.triggers.elements();
        while (e.hasMoreElements()) {
            TriggerInfo nextElement = (TriggerInfo)e.nextElement();
            if (!nextElement.sameChannelAs(info)) continue;
            return true;
        }
        return false;
    }

    private boolean addStart(StaLtaTrigger trig) {
        TriggerInfo info = new TriggerInfo(trig);
        double infoStart = info.getStartTime();
        if (infoStart < this.startTime + (double)this.coincWindow) {
            if (infoStart > this.startTime) {
                if (infoStart > this.lastStart) {
                    this.lastStart = infoStart;
                }
            } else if (infoStart + (double)this.coincWindow > this.lastStart) {
                this.startTime = infoStart;
            } else {
                return false;
            }
            if (!this.contains(info)) {
                this.triggers.addElement(info);
                Log.report(this, 1, 0, "Added " + info.getName() + "-" + this.triggerType);
            } else {
                Log.report(this, 2, 0, String.valueOf(info.getName()) + "-" + this.triggerType + " already in event.");
            }
            return true;
        }
        return false;
    }

    private boolean addEnd(StaLtaTrigger trig) {
        int indexOfStart = this.triggers.indexOf(new TriggerInfo(trig));
        if (indexOfStart < 0) {
            return false;
        }
        TriggerInfo theTrigger = (TriggerInfo)this.triggers.elementAt(indexOfStart);
        theTrigger.setEnd(trig);
        this.triggers.removeElement(theTrigger);
        Log.report(this, 3, 0, String.valueOf(trig.getStnID()) + "-" + this.triggerType + " triggered off.");
        int position = 0;
        Enumeration e = this.triggers.elements();
        while (e.hasMoreElements()) {
            TriggerInfo nextElement = (TriggerInfo)e.nextElement();
            if (nextElement.getEndTime() > theTrigger.getEndTime()) {
                this.triggers.insertElementAt(theTrigger, position);
                return true;
            }
            ++position;
        }
        this.triggers.addElement(theTrigger);
        return true;
    }

    public boolean addTrigger(StaLtaTrigger trig) {
        if (trig.getPhase() == 0) {
            return this.addStart(trig);
        }
        return this.addEnd(trig);
    }

    public boolean isActive() {
        return this.eventState == 0;
    }

    public boolean isMature() {
        boolean mature;
        if (this.eventState != 0) {
            return false;
        }
        long endOfWindow = Math.round(this.startTime + (double)this.coincWindow + (double)this.maxTrigDelay);
        boolean bl = mature = endOfWindow < System.currentTimeMillis() / 1000L;
        if (mature) {
            this.eventState = 1;
            this.endTime = this.startTime + (double)this.coincWindow;
        }
        return mature;
    }

    public boolean isExpired() {
        boolean expired;
        if (this.eventState < 1) {
            return false;
        }
        long expiryTime = Math.round(this.startTime + (double)this.maxDuration);
        boolean bl = expired = expiryTime < System.currentTimeMillis() / 1000L;
        if (expired) {
            if (this.eventState == 2) {
                this.eventState = 3;
            } else {
                this.eventState = 2;
                this.endTime = this.startTime + (double)this.maxDuration;
            }
        }
        return expired;
    }

    public boolean isComplete() {
        if (this.eventState != 1) {
            return false;
        }
        boolean complete = false;
        Enumeration e = this.triggers.elements();
        while (e.hasMoreElements()) {
            TriggerInfo nextElement = (TriggerInfo)e.nextElement();
            complete = nextElement.isComplete();
            if (!complete) break;
        }
        if (complete) {
            this.eventState = 2;
            TriggerInfo theTrigger = (TriggerInfo)this.triggers.elementAt(this.triggers.size() - 1);
            this.endTime = theTrigger.getEndTime();
        }
        return complete;
    }

    public EventPacket getPacket() {
        if (this.eventState == 3) {
            return null;
        }
        double duration = 0.0;
        if (this.endTime > 0.0) {
            duration = this.endTime - this.startTime;
        }
        String[] chnlNames = new String[this.triggers.size()];
        int i = 0;
        Enumeration e = this.triggers.elements();
        while (e.hasMoreElements()) {
            TriggerInfo nextElement = (TriggerInfo)e.nextElement();
            chnlNames[i] = nextElement.getName();
            ++i;
        }
        EventPacket ePkt = new EventPacket(this.eventState, this.triggerType, this.startTime, duration, chnlNames);
        return ePkt;
    }

    public int getTriggerCount() {
        return this.triggers.size();
    }

    public double getStartTime() {
        return this.startTime;
    }

    public double getEndTime() {
        return this.endTime;
    }

    public double getDuration() {
        return this.endTime > 0.0 ? this.endTime - this.startTime : 0.0;
    }

    public int getEventState() {
        return this.eventState;
    }

    public int getTriggerType() {
        return this.triggerType;
    }

    public double getPeakRatio() {
        int numTrigs = 0;
        double sum = 0.0;
        Enumeration e = this.triggers.elements();
        while (e.hasMoreElements()) {
            TriggerInfo nextElement = (TriggerInfo)e.nextElement();
            ++numTrigs;
            sum += nextElement.getPeakRatio();
        }
        if (numTrigs < 1) {
            numTrigs = 1;
        }
        return sum / (double)numTrigs;
    }

    public String getStationList() {
        int count = 0;
        StringBuffer stations = new StringBuffer();
        Enumeration e = this.triggers.elements();
        while (e.hasMoreElements()) {
            TriggerInfo nextElement = (TriggerInfo)e.nextElement();
            if (count > 0) {
                stations.append(", ");
            }
            stations.append(nextElement.getName());
            ++count;
        }
        return stations.toString();
    }

    public String toString() {
        return new String(String.valueOf(this.triggerType) + " " + this.format.format(this.startTime));
    }
}

