/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.naqs.config.UpdateMode;
import ca.nanometrics.naqs.config.UpdateResult;
import ca.nanometrics.naqs.stndb.DetectorType;
import ca.nanometrics.naqs.stndb.StationDatabase;
import ca.nanometrics.packet.EventHandler;
import ca.nanometrics.packet.StaLtaTrigger;
import ca.nanometrics.packet.TriggerHandler;
import ca.nanometrics.packet.TriggerPacket;
import ca.nanometrics.util.BufferedConsumer;
import ca.nanometrics.util.Log;
import java.util.Enumeration;
import java.util.Hashtable;

class EventAssociator
extends BufferedConsumer
implements TriggerHandler {
    private int coincWindow = 10;
    private int maxDuration = 20;
    private int trigsToStart = 3;
    private EventAssociatorConfig config;
    private StationDatabase stndb;
    private EventDistributor distributor;
    private EventFile eventFile;
    private EventStatus status;
    private Hashtable eventFactories;
    private boolean saveTrigs;

    public EventAssociator(EventAssociatorConfig config, StationDatabase stndb) {
        super("EventAssociator", 1000);
        this.config = config;
        this.stndb = stndb;
        this.initConfigParameters();
        this.status = new EventStatus();
        this.eventFile = new EventFile(config.getPathname(), config.getFilename());
        this.distributor = new EventDistributor();
        this.distributor.addSubscriber(this.status);
        this.distributor.addSubscriber(this.eventFile);
        this.eventFactories = new Hashtable(13);
    }

    public void update(EventAssociatorConfig newConfig, UpdateMode mode, UpdateResult result) {
        this.config.update(newConfig, mode, result);
        if (mode.isFinal()) {
            this.initConfigParameters();
        }
    }

    private void initConfigParameters() {
        this.coincWindow = this.config.getWindowSize();
        this.maxDuration = this.config.getEventTimeout();
        this.trigsToStart = this.config.getTrigsToStart();
        this.saveTrigs = this.config.getSaveTrigs();
    }

    public void addEventSubscriber(EventHandler handler) {
        this.distributor.addSubscriber(handler);
    }

    public void put(TriggerPacket p) {
        try {
            StaLtaTrigger staltaTrig = (StaLtaTrigger)p;
            if (staltaTrig.getPhase() != 1) {
                this.append(staltaTrig);
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    protected void open() {
        this.setPriority(8);
        Log.report(this, 5, 2, "starting with priority " + this.getPriority());
    }

    protected void process(Object obj) {
        int triggerID;
        EventFactory newFactory;
        StaLtaTrigger trig = (StaLtaTrigger)obj;
        if (this.saveTrigs) {
            this.eventFile.put(trig);
        }
        if ((newFactory = (EventFactory)this.eventFactories.get(new Integer(triggerID = trig.getTriggerID()))) == null) {
            DetectorType theDetector = this.stndb.getDetector(triggerID);
            int maxTrigDelay = theDetector.getStcDelay();
            newFactory = new EventFactory(triggerID, this.trigsToStart, this.coincWindow, this.maxDuration, maxTrigDelay, this.distributor);
            this.eventFactories.put(new Integer(triggerID), newFactory);
        }
        newFactory.process(trig);
    }

    public void tick() {
        Enumeration e = this.eventFactories.elements();
        while (e.hasMoreElements()) {
            EventFactory theFactory = (EventFactory)e.nextElement();
            theFactory.tick();
        }
    }

    protected void close() {
        Log.report(this, 6, 1, "quitting ...");
    }

    public void reportStatus(String hint) {
        this.status.reportStatus(hint);
    }

    public synchronized void reportSummary() {
        this.status.reportSummary();
    }
}

