/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.naqs.config.BoolEnum;
import ca.nanometrics.naqs.config.BoolParam;
import ca.nanometrics.naqs.config.IntParam;
import ca.nanometrics.naqs.config.IntRange;
import ca.nanometrics.naqs.config.SerialInStream;
import ca.nanometrics.naqs.config.SerialOutStream;
import ca.nanometrics.naqs.config.Serialisable;
import ca.nanometrics.naqs.config.SerialiseException;
import ca.nanometrics.naqs.config.StringParam;
import ca.nanometrics.naqs.config.StringRange;
import ca.nanometrics.naqs.config.UpdateException;
import ca.nanometrics.naqs.config.UpdateMode;
import ca.nanometrics.naqs.config.UpdateResult;
import ca.nanometrics.util.SimpleParser;
import java.io.IOException;

public class EventAssociatorConfig
implements Serialisable {
    private StringRange namelen = new StringRange(1, 128);
    private StringParam pathname = new StringParam("Event Directory", "data", 18, this.namelen);
    private StringParam filename = new StringParam("Event filename", "NaqsNT.elf", 18, this.namelen);
    private IntRange trigCount = new IntRange(1, 100);
    private IntParam trigsToStart = new IntParam("Trigs To Start", 3, 18, this.trigCount);
    private IntRange timeRange = new IntRange(0, 3600);
    private IntParam coinWindowSize = new IntParam("Coincidence Window", 20, 18, this.timeRange);
    private IntParam eventTimeout = new IntParam("Event Timeout", 20, 18, this.timeRange);
    private BoolEnum saveChoices = new BoolEnum("Yes", "No");
    private BoolParam saveTrigs = new BoolParam("Trigs", true, 0, this.saveChoices);

    public void update(EventAssociatorConfig newConfig, UpdateMode mode, UpdateResult result) {
        try {
            this.pathname.putValue(newConfig.getPathname(), mode);
        }
        catch (UpdateException ue) {
            result.postException(this, ue);
        }
        try {
            this.filename.putValue(newConfig.getFilename(), mode);
        }
        catch (UpdateException ue) {
            result.postException(this, ue);
        }
        try {
            this.trigsToStart.putValue(newConfig.getTrigsToStart(), mode);
        }
        catch (UpdateException ue) {
            result.postException(this, ue);
        }
        try {
            this.coinWindowSize.putValue(newConfig.getWindowSize(), mode);
        }
        catch (UpdateException ue) {
            result.postException(this, ue);
        }
        try {
            this.eventTimeout.putValue(newConfig.getEventTimeout(), mode);
        }
        catch (UpdateException ue) {
            result.postException(this, ue);
        }
        try {
            this.saveTrigs.putValue(newConfig.getSaveTrigs(), mode);
        }
        catch (UpdateException ue) {
            result.postException(this, ue);
        }
    }

    public String getPathname() {
        return this.pathname.getValue();
    }

    public String getFilename() {
        return this.filename.getValue();
    }

    public int getTrigsToStart() {
        return this.trigsToStart.getValue();
    }

    public int getEventTimeout() {
        return this.eventTimeout.getValue();
    }

    public int getWindowSize() {
        return this.coinWindowSize.getValue();
    }

    public boolean getSaveTrigs() {
        return this.saveTrigs.getValue();
    }

    public void setPathname(String name) {
        this.pathname.putValue(name);
    }

    public void setFilename(String name) {
        this.filename.putValue(name);
    }

    public void setTrigsToStart(int newVal) {
        this.trigsToStart.putValue(newVal);
    }

    public void setEventTimeout(int waitVal) {
        this.eventTimeout.putValue(waitVal);
    }

    public void setWindowSize(int sizeVal) {
        this.coinWindowSize.putValue(sizeVal);
    }

    public void setSaveTrigs(boolean save) {
        this.saveTrigs.putValue(save);
    }

    public void saveGuts(SerialOutStream strm) throws SerialiseException {
        strm.serialiseObject(this.namelen);
        strm.serialiseObject(this.trigCount);
        strm.serialiseObject(this.timeRange);
        this.pathname.saveGuts(strm);
        this.filename.saveGuts(strm);
        this.trigsToStart.saveGuts(strm);
        this.coinWindowSize.saveGuts(strm);
        this.eventTimeout.saveGuts(strm);
        this.saveTrigs.saveGuts(strm);
    }

    public void restoreGuts(SerialInStream strm) throws SerialiseException {
        strm.deserialiseObject(this.namelen);
        strm.deserialiseObject(this.trigCount);
        strm.deserialiseObject(this.timeRange);
        this.pathname.restoreGuts(strm);
        this.filename.restoreGuts(strm);
        this.trigsToStart.restoreGuts(strm);
        this.coinWindowSize.restoreGuts(strm);
        this.eventTimeout.restoreGuts(strm);
        this.saveTrigs.restoreGuts(strm);
    }

    public void load(SimpleParser input) throws IOException {
        input.getHeader("EventAssociator");
        this.setPathname(input.readString("EventPath"));
        this.setFilename(input.readString("EventFile"));
        this.setTrigsToStart(input.readInt("TrigsToStart"));
        this.setWindowSize(input.readInt("CoincidenceWindow"));
        this.setEventTimeout(input.readInt("EventTimeout"));
        this.saveTrigs.putValue(input.readString("SaveTriggers"));
    }
}

