/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.alert.Alert;
import ca.nanometrics.packet.EventHandler;
import ca.nanometrics.packet.EventPacket;
import ca.nanometrics.packet.StaLtaTrigger;
import ca.nanometrics.util.Format;
import ca.nanometrics.util.Log;
import ca.nanometrics.util.NmxDateFormat;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.Vector;

class EventFactory {
    private int triggerType;
    private int coincWindow;
    private int maxDuration;
    private int maxTrigDelay;
    private TriggerTimeTable trigTable;
    private Vector events;
    private EventHandler handler;
    private DecimalFormat durationFormatter;
    private NmxDateFormat dateFormatter = new NmxDateFormat();

    public EventFactory(int type, int trigsForEvent, int windowSecs, int maxDurSecs, int maxDelaySecs, EventHandler dest) {
        this.triggerType = type;
        this.coincWindow = windowSecs;
        this.maxDuration = maxDurSecs;
        this.maxTrigDelay = maxDelaySecs;
        this.handler = dest;
        this.trigTable = new TriggerTimeTable(trigsForEvent, this.coincWindow, this.maxTrigDelay);
        this.events = new Vector(3, 3);
        this.durationFormatter = new DecimalFormat("00000");
    }

    private void sendAlertMessage(Event event) {
        double peakRatio = event.getPeakRatio();
        if (peakRatio > 1000000.0) {
            peakRatio = 1000000.0;
        }
        int level = (int)peakRatio;
        Format durFmt = new Format("%.1f");
        StringBuffer format = new StringBuffer();
        format.append("Naqs detected seismic event\n");
        format.append("  Start time: %1\n");
        format.append("  Duration (seconds): %2\n");
        format.append("  Trigger type: %3\n");
        format.append("  Number of triggers: %4\n");
        format.append("  Peak Sta/Lta: %p\n");
        format.append("  Stations:  %5\n");
        StringBuffer args = new StringBuffer();
        args.append("/" + this.dateFormatter.format(event.getStartTime()));
        args.append("/" + durFmt.form(event.getDuration()));
        args.append("/" + event.getTriggerType());
        args.append("/" + event.getTriggerCount());
        args.append("/" + event.getStationList());
        Alert.report("NaqsEvent", level, format.toString(), args.toString());
    }

    private void forwardEvent(Event event) {
        if (event.getEventState() == 2) {
            this.sendAlertMessage(event);
        }
        this.handler.put(event.getPacket());
    }

    public void process(StaLtaTrigger trig) {
        TriggerInfo[] triggers;
        boolean added = false;
        Enumeration e = this.events.elements();
        while (e.hasMoreElements()) {
            Event nextElement = (Event)e.nextElement();
            if (!nextElement.addTrigger(trig)) continue;
            added = true;
            break;
        }
        if (!added) {
            this.trigTable.addTrigger(trig);
        }
        if (trig.getPhase() == 0 && (triggers = this.trigTable.associateTrigs()) != null) {
            Event event = new Event(triggers, this.triggerType, this.coincWindow, this.maxDuration, this.maxTrigDelay);
            this.forwardEvent(event);
            this.events.addElement(event);
            Log.report(this, 1, 2, "Event detected: " + event.toString());
        }
    }

    public void tick() {
        this.trigTable.removeMature();
        Enumeration e = this.events.elements();
        while (e.hasMoreElements()) {
            Event nextEvent = (Event)e.nextElement();
            if (nextEvent.isMature()) {
                this.forwardEvent(nextEvent);
                Log.report(this, 4, 1, "Window closed: " + nextEvent.toString());
                continue;
            }
            if (nextEvent.isComplete()) {
                this.forwardEvent(nextEvent);
                Log.report(this, 2, 2, "Event complete: " + nextEvent.toString());
                continue;
            }
            if (!nextEvent.isExpired()) continue;
            EventPacket p = nextEvent.getPacket();
            if (p != null) {
                this.forwardEvent(nextEvent);
                Log.report(this, 3, 2, "Event timed out waiting for trigger off.");
            } else {
                Log.report(this, 5, 1, "Event expired.");
            }
            this.events.removeElement(nextEvent);
        }
    }
}

