/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.packet.EventHandler;
import ca.nanometrics.packet.EventPacket;
import ca.nanometrics.packet.StaLtaTrigger;
import ca.nanometrics.packet.TriggerHandler;
import ca.nanometrics.packet.TriggerPacket;
import ca.nanometrics.util.Log;
import ca.nanometrics.util.NmxDateFormat;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;

public class EventFile
implements EventHandler,
TriggerHandler {
    public static final String DEFAULT_EXTENSION = "elf";
    private DecimalFormat durationFormatter = new DecimalFormat("00000");
    private NmxDateFormat eventDateFormatter = new NmxDateFormat("EEE MMM dd HH:mm:ss yyyy");
    private NmxDateFormat trigDateFormatter = new NmxDateFormat("yyyy-MM-dd-HH:mm:ss.SSS ");
    private NmxDateFormat fileDateFmt = new NmxDateFormat("_yyyyMMdd");
    private String eventPath = ".";
    private String eventFile = "Naqs.elf";

    public EventFile(String pathname, String filename) {
        this.setPathAndFile(pathname, filename);
    }

    private void write(StaLtaTrigger trig) {
        try {
            String channel = String.valueOf(trig.getStnID()) + "-" + trig.getTriggerID();
            int len = channel.length();
            int after = 16 - len;
            int before = after / 2;
            after -= before;
            StringBuffer sb = new StringBuffer();
            while (before-- > 0) {
                sb.append(" ");
            }
            sb.append(channel);
            while (after-- > 0) {
                sb.append(" ");
            }
            channel = sb.toString();
            double startDate = trig.getStartTime();
            PrintWriter elfWriter = this.open(startDate);
            elfWriter.println("   T        " + this.trigDateFormatter.format(startDate) + " " + channel + " " + this.durationFormatter.format(trig.getDuration()) + "                    .");
            elfWriter.flush();
            elfWriter.close();
        }
        catch (IOException e) {
            Log.report(this, 2, 4, "Unable to write trigger to ELF: " + e.getMessage());
        }
    }

    private void write(EventPacket pkt) {
        try {
            double startDate = pkt.getStart();
            PrintWriter elfWriter = this.open(startDate);
            elfWriter.println("   E        " + this.eventDateFormatter.format(startDate) + "        *         " + this.durationFormatter.format(pkt.getDuration()) + "                    .");
            elfWriter.flush();
            elfWriter.close();
        }
        catch (IOException e) {
            Log.report(this, 2, 4, "Unable to write event to ELF: " + e.getMessage());
        }
    }

    public void put(EventPacket pkt) {
        if (pkt.getEventType() == 2) {
            this.write(pkt);
        }
    }

    public void put(TriggerPacket pkt) {
        StaLtaTrigger trig;
        if (pkt instanceof StaLtaTrigger && (trig = (StaLtaTrigger)pkt).getPhase() == 2) {
            this.write(trig);
        }
    }

    private PrintWriter open(double startDate) throws IOException {
        File path = new File(this.eventPath);
        path.mkdirs();
        String elfName = this.buildElfName(startDate);
        File file = new File(this.eventPath, elfName);
        PrintWriter writer = new PrintWriter(new FileWriter(file.getPath(), true));
        return writer;
    }

    public String buildElfName(double startDate) {
        String filename;
        String baseName = filename = this.eventFile;
        String extension = "";
        int lastDot = filename.lastIndexOf(46);
        if (lastDot >= 0) {
            baseName = filename.substring(0, lastDot);
            extension = filename.substring(lastDot + 1);
        }
        if (extension.length() < 1) {
            extension = DEFAULT_EXTENSION;
        }
        String elfName = String.valueOf(baseName) + this.fileDateFmt.format(startDate) + "." + extension;
        return elfName;
    }

    public void setPathAndFile(String pathname, String filename) {
        this.eventPath = pathname;
        this.eventFile = filename;
    }
}

