/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.packet.EventHandler;
import ca.nanometrics.packet.EventPacket;
import ca.nanometrics.util.Log;
import ca.nanometrics.util.NmxDateFormat;

public class EventStatus
implements EventHandler {
    private String lastReportTime;
    private String lastEventTime = null;
    private int eventCount;
    private NmxDateFormat dateFormat = new NmxDateFormat("yyyy/MM/dd_HH:mm:ss");

    public EventStatus() {
        this.resetStatus();
    }

    protected synchronized void reportStatus() {
        Log.report(this, 0, 2, "Events detected since " + this.lastReportTime + ": " + this.eventCount);
        if (this.lastEventTime != null) {
            Log.report(this, 0, 2, "Last event time: " + this.lastEventTime);
        }
    }

    protected void resetStatus() {
        this.lastReportTime = this.dateFormat.format(System.currentTimeMillis() / 1000L);
        this.eventCount = 0;
    }

    public synchronized void reportSummary() {
        this.reportStatus();
        this.resetStatus();
    }

    public void reportStatus(String hint) {
        if (hint.equals("ALL") || hint.equals("SUMMARY") || hint.equals("EVENTS")) {
            this.reportStatus();
        }
    }

    public void put(EventPacket pkt) {
        if (pkt.getEventType() == 0) {
            this.lastEventTime = this.dateFormat.format(System.currentTimeMillis() / 1000L);
            ++this.eventCount;
        }
    }
}

