/*
 * Decompiled with CFR 0.152.
 */
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class GroupMonitor {
    private int minTimeout = 5;
    private int maxTimeout = 10;
    private int ticksToMin;
    private int ticksToMax;
    private Set monitors = new TreeSet();

    public GroupMonitor(int minTimeoutSec, int maxTimeoutSec) {
        this.minTimeout = minTimeoutSec;
        this.maxTimeout = maxTimeoutSec;
    }

    public void add(StateMonitor monitor) {
        this.monitors.add(monitor);
        this.ticksToMin = this.minTimeout;
        if (this.monitors.size() == 1) {
            this.ticksToMax = this.maxTimeout;
        }
    }

    public void remove(StateMonitor monitor) {
        this.monitors.remove(monitor);
    }

    public boolean test() {
        if (this.monitors.size() > 0) {
            --this.ticksToMin;
            --this.ticksToMax;
            return this.ticksToMin <= 0 || this.ticksToMax <= 0;
        }
        return false;
    }

    public Set getMonitors() {
        TreeSet set = new TreeSet();
        Iterator iter = this.monitors.iterator();
        while (iter.hasNext()) {
            set.add(iter.next());
        }
        return set;
    }

    public void clear() {
        this.monitors.clear();
    }
}

