/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.bundle.EventBundle;
import ca.nanometrics.bundle.SohBundle;
import ca.nanometrics.bundle.SohBundleFactory;
import ca.nanometrics.msg.CalibrationCommand;
import ca.nanometrics.msg.CalibrationEventMessage;
import ca.nanometrics.msg.CalibrationInfo;
import ca.nanometrics.msg.CalibrationInfoTable;
import ca.nanometrics.msg.CalibrationList;
import ca.nanometrics.msg.CalibrationResult;
import ca.nanometrics.msg.CancelCommandRequest;
import ca.nanometrics.msg.ChannelList;
import ca.nanometrics.msg.CommandResult;
import ca.nanometrics.msg.MassCenterCommand;
import ca.nanometrics.msg.MassCenterResult;
import ca.nanometrics.msg.MsgSubscriber;
import ca.nanometrics.msg.SensorCommandRequest;
import ca.nanometrics.naqs.config.UpdateMode;
import ca.nanometrics.naqs.config.UpdateResult;
import ca.nanometrics.naqs.stndb.StationDatabase;
import ca.nanometrics.packet.CalibrationCommandPacket;
import ca.nanometrics.packet.CancelCalibrationCommandPacket;
import ca.nanometrics.packet.ChannelKey;
import ca.nanometrics.packet.DoDRequestPacket;
import ca.nanometrics.packet.HrdCalPacket;
import ca.nanometrics.packet.HrdCommandConnector;
import ca.nanometrics.packet.HrdCommandHandler;
import ca.nanometrics.packet.HrdCommandPacket;
import ca.nanometrics.packet.LogPacket;
import ca.nanometrics.packet.NmxPacket;
import ca.nanometrics.packet.NmxPacketHandler;
import ca.nanometrics.packet.Packable;
import ca.nanometrics.packet.SohPacket;
import ca.nanometrics.packet.SohPacketHandler;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.util.Log;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;

public class HrdCommandManager
implements MsgHandler,
NmxPacketHandler,
SohPacketHandler {
    private static final String COMMAND_OK = "OK";
    private CalibratorConfig config;
    private StationDatabase stndb;
    private HrdCommandConnector handler;
    private CalibrationTracker calTracker;

    public HrdCommandManager(CalibratorConfig theConfig, StationDatabase theStndb) {
        this.config = theConfig;
        this.stndb = theStndb;
        this.handler = new HrdCommandConnector(null);
        this.calTracker = new CalibrationTracker();
        this.calTracker.start();
    }

    public void update(CalibratorConfig newConfig, UpdateMode mode, UpdateResult result) {
        this.config.update(newConfig, mode, result);
    }

    public void setHandler(HrdCommandHandler newHandler) {
        this.handler.setHandler(newHandler);
    }

    public void setCalibrationTracker(CalibrationTracker _calTracker) {
        this.calTracker = _calTracker;
    }

    private HrdCommandPacket getCommandPacket(byte[] packetBytes) {
        HrdCommandPacket command = null;
        try {
            command = packetBytes[6] == 8 ? new CalibrationCommandPacket(packetBytes, 0, packetBytes.length) : (packetBytes[6] == 2 ? new DoDRequestPacket(packetBytes, 0, packetBytes.length) : new HrdCalPacket(packetBytes, 0, packetBytes.length));
        }
        catch (InvalidInputException iie) {
            return null;
        }
        return command;
    }

    private void calibrate(SensorCommandRequest commandRequest, MsgSubscriber subscriber) {
        String message;
        if (commandRequest instanceof CancelCommandRequest) {
            this.cancelCalibration((CancelCommandRequest)commandRequest, subscriber);
            return;
        }
        String instrument = commandRequest.getInstrument();
        String identifier = commandRequest.getIdentifier();
        String username = commandRequest.getUsername();
        float duration = 0.0f;
        HrdCommandPacket command = this.getCommandPacket(commandRequest.getCommandPacketBytes());
        if (command == null) {
            subscriber.send(new CommandResult("Error: Unknown command received.", new boolean[0], identifier));
            return;
        }
        if (command instanceof CalibrationCommandPacket) {
            duration = ((CalibrationCommandPacket)command).getDuration();
        } else if (command instanceof HrdCalPacket) {
            duration = ((HrdCalPacket)command).getDuration();
        } else {
            subscriber.send(new CommandResult("Error: Unknown command received.", null, identifier));
            return;
        }
        int instrumentID = command.getInstrumentID();
        ChannelList cl = this.stndb.getChannelList();
        int numChannels = commandRequest.getNumChannels();
        boolean[] vc = new boolean[numChannels];
        boolean allBad = true;
        int chani = 0;
        while (chani < numChannels) {
            String channel = commandRequest.getChannel(chani);
            String name = String.valueOf(instrument) + "." + channel;
            if (cl.contains(name)) {
                vc[chani] = true;
                allBad = false;
            } else {
                vc[chani] = false;
            }
            ++chani;
        }
        if (allBad) {
            message = new String("Error: No channels recognized");
        } else if (this.calTracker.isInstrumentAvailable(instrumentID)) {
            this.calTracker.addCalibration(instrumentID, identifier, duration, subscriber);
            this.handler.put(command);
            Log.report(this, 1, 2, "Username: " + username + ". Calibration sent to " + instrumentID + " from " + subscriber);
            message = new String("Calibration command sent. ");
        } else {
            message = new String("Conflict: Command not sent to instrument " + instrumentID + ". Already under calibration. ");
            Log.report(this, 2, 1, "Request from " + subscriber + " not completed. " + message);
        }
        subscriber.send(new CommandResult(message, vc, identifier));
    }

    private void cancelCalibration(CancelCommandRequest commandRequest, MsgSubscriber subscriber) {
        String identifier = commandRequest.getIdentifier();
        CalibrationList cl = this.calTracker.getCurrentCalibrations();
        if (identifier.equals("naqsCancelAll")) {
            Log.report(this, 4, 2, "User " + commandRequest.getUsername() + " cancelling all calibrations");
            Iterator iter = cl.messageIterator();
            while (iter.hasNext()) {
                CalibrationEventMessage cem = (CalibrationEventMessage)iter.next();
                int instrumentID = cem.getInstrumentID();
                identifier = cem.getIdentifier();
                this.cancelCalibration(identifier, ChannelKey.getKeyOf(1, 0, instrumentID), subscriber);
                Log.report(this, 5, 2, "Calibration cancelled: " + identifier + " by: " + commandRequest.getUsername());
            }
        } else if (cl.contains(identifier)) {
            String dotName = String.valueOf(commandRequest.getInstrument()) + "." + commandRequest.getChannel(0);
            this.cancelCalibration(identifier, this.stndb.getChannelList().getKeyOf(dotName), subscriber);
            Log.report(this, 6, 2, "Calibration cancelled: " + identifier + " by: " + commandRequest.getUsername());
        }
    }

    private void cancelCalibration(String identifier, int channelKey, MsgSubscriber sub) {
        CalibrationInfoTable cit = this.stndb.getCalibrationTable();
        CalibrationInfo info = cit.get(channelKey);
        HrdCommandPacket cancelPacket = info.getCalSource() == 1 ? new CancelCalibrationCommandPacket((int)(System.currentTimeMillis() / 1000L), info.getInstrumentID(), identifier) : new HrdCalPacket((int)(System.currentTimeMillis() / 1000L), info.getInstrumentID(), 0, 1, 1.0f, 0.0f, 0, 0, 0);
        this.calTracker.cancelCalibration(identifier);
        this.handler.put(cancelPacket);
        sub.send(new CommandResult("Calibration Cancelled", new boolean[0], identifier));
        Log.report(this, 7, 2, "Calibration cancelled: " + identifier);
    }

    private String validateCalCommand(CalibrationCommand command) {
        long permission = CalibrationCommand.encode(this.config.getPassword());
        if (permission != command.getPermission()) {
            return "Invalid password";
        }
        if (command.getChannelCount() < 1) {
            return "Channel count < 1";
        }
        if (command.getFrequency() <= 0.0f) {
            return "Frequency <= 0";
        }
        if (command.getAmplitude() < 0.0f) {
            return "Amplitude < 0";
        }
        if (command.getDuration() < 1.0f) {
            return "Duration < 1";
        }
        return COMMAND_OK;
    }

    private void calibrate(CalibrationCommand command, MsgSubscriber subscriber) {
        CalibrationSet set;
        String packetCheck = this.validateCalCommand(command);
        if (packetCheck != COMMAND_OK) {
            subscriber.send(new CalibrationResult("Error: " + packetCheck));
            Log.report(this, 8, 3, "Invalid calibration command from " + subscriber + ": " + packetCheck);
            return;
        }
        StringBuffer msgBuffer = new StringBuffer();
        Hashtable<Integer, CalibrationSet> digitizers = new Hashtable<Integer, CalibrationSet>();
        CalibrationInfoTable cit = this.stndb.getCalibrationTable();
        int[] channels = command.getChannels();
        int inx = 0;
        while (inx < channels.length) {
            CalibrationInfo info = cit.get(channels[inx]);
            if (info != null) {
                int ID = info.getInstrumentID();
                Integer key = new Integer(ID);
                set = (CalibrationSet)digitizers.get(key);
                if (set == null) {
                    digitizers.put(key, new CalibrationSet(info));
                } else {
                    set.addChannel(info);
                }
            } else {
                msgBuffer.append("bad channel: " + channels[inx] + "\n");
            }
            ++inx;
        }
        float frequency = command.getFrequency();
        float amplitude = command.getAmplitude();
        float duration = command.getDuration();
        Enumeration e = digitizers.elements();
        while (e.hasMoreElements()) {
            set = (CalibrationSet)e.nextElement();
            float signalAmp = (float)set.getClippedAmplitude(frequency, amplitude);
            int instrumentID = set.getInstrumentID();
            if (this.calTracker.isInstrumentAvailable(instrumentID)) {
                Log.report(this, 9, 2, "Calibration sent to " + instrumentID + " from " + subscriber);
                msgBuffer.append("Calibration command sent to " + instrumentID + ".\n");
                HrdCalPacket hcp = new HrdCalPacket((int)(System.currentTimeMillis() / 1000L), set.getInstrumentID(), set.getRelayBits(), 1, frequency, signalAmp, (int)duration, set.getEnableBits(), set.getCalType());
                this.handler.put(hcp);
                continue;
            }
            msgBuffer.append("Conflict: Command not sent to instrument " + instrumentID + ". Already under calibration. \n");
            Log.report(this, 10, 1, "Request from " + subscriber + " not completed. " + msgBuffer.toString());
        }
        subscriber.send(new CalibrationResult(msgBuffer.toString()));
    }

    private String validateCenterCommand(MassCenterCommand command) {
        long permission = CalibrationCommand.encode(this.config.getPassword());
        if (permission != command.getPermission()) {
            return "Invalid password";
        }
        if (command.getChannelCount() < 1) {
            return "Channel count < 1";
        }
        if (command.getDuration() < 1.0f) {
            return "Duration < 1";
        }
        return COMMAND_OK;
    }

    private void massCenter(MassCenterCommand command, MsgSubscriber subscriber) {
        String packetCheck = this.validateCenterCommand(command);
        if (packetCheck != COMMAND_OK) {
            subscriber.send(new MassCenterResult("Error: " + packetCheck));
            Log.report(this, 11, 3, "Invalid mass center command from " + subscriber + ": " + packetCheck);
            return;
        }
        Hashtable<Integer, MassCenterSet> digitizers = new Hashtable<Integer, MassCenterSet>();
        CalibrationInfoTable cit = this.stndb.getCalibrationTable();
        int[] channels = command.getChannels();
        int validChannels = 0;
        int inx = 0;
        while (inx < channels.length) {
            CalibrationInfo info = cit.get(channels[inx]);
            if (info != null) {
                ++validChannels;
                int ID = info.getInstrumentID();
                Integer key = new Integer(ID);
                MassCenterSet set = (MassCenterSet)digitizers.get(key);
                if (set == null) {
                    digitizers.put(key, new MassCenterSet(info));
                } else {
                    set.addChannel(info);
                }
            }
            ++inx;
        }
        Enumeration e = digitizers.elements();
        while (e.hasMoreElements()) {
            MassCenterSet set = (MassCenterSet)e.nextElement();
            HrdCalPacket hcp = new HrdCalPacket((int)(System.currentTimeMillis() / 1000L), set.getInstrumentID(), set.getRelayBits(), 1, 1.0f, set.getAmplitude(), (int)set.getDuration(), set.getEnableBits(), set.getCalType());
            this.handler.put(hcp);
        }
        String msg = validChannels < channels.length ? "Centered " + validChannels + " channels " + "out of " + channels.length + " specified.  " : "Centered all channels OK";
        Log.report(this, 12, 2, "Mass-centered " + validChannels + " channels from " + subscriber);
        subscriber.send(new MassCenterResult(msg));
    }

    private void handleDataOnDemand(DoDRequestPacket pkt) {
        this.handler.put(pkt);
    }

    public boolean handleMessage(Packable packet, MsgSubscriber subscriber) {
        if (packet instanceof SensorCommandRequest) {
            this.calibrate((SensorCommandRequest)packet, subscriber);
            return true;
        }
        if (packet instanceof CalibrationCommand) {
            this.calibrate((CalibrationCommand)packet, subscriber);
            return true;
        }
        if (packet instanceof MassCenterCommand) {
            this.massCenter((MassCenterCommand)packet, subscriber);
            return true;
        }
        if (packet instanceof DoDRequestPacket) {
            this.handleDataOnDemand((DoDRequestPacket)packet);
        }
        return false;
    }

    public void put(NmxPacket p) {
        if (p instanceof LogPacket && ((LogPacket)p).getMessage().matches(".*alibration.*")) {
            try {
                CalibrationEventMessage calEventMsg = new CalibrationEventMessage((LogPacket)p);
                this.calTracker.put(calEventMsg);
            }
            catch (InvalidInputException invalidInputException) {
                // empty catch block
            }
        }
    }

    public void put(SohPacket packet) {
        int i = 0;
        while (i < packet.getNumBundles()) {
            SohBundle bundle = SohBundleFactory.createBundle(packet.getBundle(i), 0);
            if (bundle != null && bundle.getType() == 24 && ((EventBundle)bundle).getCause() == 4) {
                this.processCalibrationEvent(packet.getInstrumentID(), packet.getInstrumentName(), ((EventBundle)bundle).getTrigger(0) == 1, ((EventBundle)bundle).getTrigger(1) == 1, ((EventBundle)bundle).getTrigger(2) == 1, ((EventBundle)bundle).getTrigger(3) == 1, ((EventBundle)bundle).getTrigger(4) == 1, ((EventBundle)bundle).getTrigger(5) == 1, new Date(((EventBundle)bundle).getLongSeconds() * 1000L), ((EventBundle)bundle).getEndTime());
            }
            ++i;
        }
    }

    private void processCalibrationEvent(int instrumentID, String instrumentName, boolean inclChannel1, boolean inclChannel2, boolean inclChannel3, boolean inclChannel4, boolean inclChannel5, boolean inclChannel6, Date startTime, long duration) {
        String identifier = this.calTracker.lookupIdentifier(instrumentID);
        if (identifier == null) {
            Log.report(this, 13, 1, "Received calibration event for unlisted calibration: >>> instID: " + instrumentID + ", instName: " + instrumentName + ", startTime: " + startTime + ", duration=" + duration);
            return;
        }
        String startMessage = "Calibration started.";
        CalibrationEventMessage startCem = new CalibrationEventMessage(instrumentID, startMessage, identifier);
        startCem.setMsgTime(startTime);
        this.calTracker.put(startCem);
        String endMessage = "Calibration finished.";
        Date finishTime = new Date(startTime.getTime() + duration);
        CalibrationEventMessage endCem = new CalibrationEventMessage(instrumentID, endMessage, identifier);
        startCem.setMsgTime(finishTime);
        this.calTracker.put(endCem);
        Log.report(this, 14, 0, "Calibration event: >>> instID: " + instrumentID + ", instName: " + instrumentName + ", startTime: " + startTime + ", duration=" + duration);
    }
}

