/*
 * Decompiled with CFR 0.152.
 */
public class IirFilter {
    public static final double krdPi = 3.141592654;
    private double rdA1 = 0.0;
    private double rdA2 = 0.0;
    private double rdB1 = 0.0;
    private double rdB2 = 0.0;
    private double rdGain = 1.0;
    private double rdW1 = 0.0;
    private double rdW2 = 0.0;
    private double rdVal = 0.0;

    public void initialize(int usOrder, boolean fIsHP, double rdFreq, double rdDamp, int sampleRate) {
        double rdC = IirFilter.digFreq(rdFreq, sampleRate);
        if (!fIsHP) {
            rdC = 1.0 / rdC;
        }
        if (usOrder == 1) {
            this.rdGain = 1.0 / (1.0 + rdC);
            this.rdA1 = this.rdGain * (1.0 - rdC);
            this.rdA2 = 0.0;
            this.rdB1 = 1.0;
            this.rdB2 = 0.0;
        } else if (usOrder == 2) {
            this.rdGain = 1.0 / (1.0 + rdC * (rdDamp + rdC));
            this.rdA1 = this.rdGain * 2.0 * (1.0 - rdC * rdC);
            this.rdA2 = this.rdGain * (1.0 + rdC * (rdC - rdDamp));
            this.rdB1 = 2.0;
            this.rdB2 = 1.0;
        } else {
            this.rdGain = 1.0;
            this.rdA1 = 0.0;
            this.rdA2 = 0.0;
            this.rdB1 = 0.0;
            this.rdB2 = 0.0;
        }
        if (fIsHP) {
            this.rdA1 = -this.rdA1;
            this.rdB1 = -this.rdB1;
        }
    }

    public void reset(double rdInput) {
        this.rdW2 = this.rdW1 = rdInput / (1.0 + this.rdA1 + this.rdA2);
        this.rdVal = this.rdGain * this.rdW1 * (1.0 + this.rdB1 + this.rdB2);
    }

    public void reset() {
        this.reset(0.0);
    }

    public void update(double rdInput) {
        double rdTemp = rdInput - this.rdA1 * this.rdW1 - this.rdA2 * this.rdW2;
        this.rdVal = this.rdGain * (rdTemp + this.rdB1 * this.rdW1 + this.rdB2 * this.rdW2);
        this.rdW2 = this.rdW1;
        this.rdW1 = rdTemp;
    }

    public double getVal() {
        return this.rdVal;
    }

    public static double digFreq(double rdFreq, int sampleRate) {
        double rdLim = (double)sampleRate * 1.0E-6;
        if (rdFreq < rdLim) {
            rdFreq = rdLim;
        } else if (rdFreq > (rdLim = 0.5 * (double)sampleRate - rdLim)) {
            rdFreq = rdLim;
        }
        return Math.tan(3.141592654 * rdFreq / (double)sampleRate);
    }
}

