/*
 * Decompiled with CFR 0.152.
 */
public class LP1Filter {
    private double rdA1 = 0.0;
    private double rdGain = 1.0;
    private double rdW = 0.0;
    private double rdVal = 0.0;

    public void initialize(double rdFreq, int sampleRate) {
        double rdC = 1.0 / IirFilter.digFreq(rdFreq, sampleRate);
        this.rdGain = 1.0 / (1.0 + rdC);
        this.rdA1 = this.rdGain * (1.0 - rdC);
    }

    public void reset(double rdInput) {
        this.rdW = rdInput / (1.0 + this.rdA1);
        this.update(rdInput);
    }

    public void reset() {
        this.reset(0.0);
    }

    public void update(double rdInput) {
        double rdTemp = rdInput - this.rdA1 * this.rdW;
        this.rdVal = this.rdGain * (rdTemp + this.rdW);
        this.rdW = rdTemp;
    }

    public double getVal() {
        return this.rdVal;
    }
}

