/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.msg.CalibrationInfo;

public class MassCenterSet {
    public static final int HRD_CAL = 0;
    public static final int TRIDENT_CAL = 1;
    public static final int CURRENT_CAL = 0;
    public static final int VOLTAGE_CAL = 1;
    public static final int HRD_VOLTAGE = 0;
    public static final int TRIDENT_VOLTS = 1;
    public static final int TRIDENT_AMPS = 2;
    private int ID = -1;
    private int relayBits = 0;
    private int enableBits = 0;
    private double duration = 1.0;
    private int calUnits = 0;
    private int calSource;

    public MassCenterSet() {
    }

    public MassCenterSet(CalibrationInfo channel) {
        this.add(channel);
    }

    private void add(CalibrationInfo channel) {
        int enable;
        if (this.ID < 0) {
            this.ID = channel.getInstrumentID();
            this.calUnits = channel.getCalUnits();
            this.calSource = channel.getCalSource();
        }
        if ((enable = channel.getMassCenterEnable()) < 1 || enable > 3) {
            enable = 0;
        }
        this.enableBits |= 1 << enable >> 1;
        double channelDuration = channel.getMassCenterDuration();
        if (this.duration < channelDuration) {
            this.duration = channelDuration;
        }
    }

    public boolean isCompatible(CalibrationInfo channel) {
        if (this.ID >= 0 && channel.getInstrumentID() != this.ID) {
            return false;
        }
        return this.getCalUnits() == channel.getCalUnits() && this.getCalSource() == channel.getCalSource();
    }

    public boolean addChannel(CalibrationInfo channel) {
        if (this.isCompatible(channel)) {
            this.add(channel);
            return true;
        }
        return false;
    }

    public int getCalType() {
        if (this.calSource == 1) {
            if (this.calUnits == 1) {
                return 1;
            }
            return 2;
        }
        return 0;
    }

    public float getAmplitude() {
        if (this.calSource == 1) {
            return 0.0f;
        }
        return 1.0f;
    }

    protected int getCalUnits() {
        return this.calUnits;
    }

    protected int getRelayBits() {
        return this.relayBits;
    }

    protected int getEnableBits() {
        return this.enableBits;
    }

    protected int getInstrumentID() {
        return this.ID;
    }

    protected double getDuration() {
        return this.duration;
    }

    protected int getCalSource() {
        return this.calSource;
    }
}

