/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.alert.AlertSenderConfig;
import ca.nanometrics.naqs.config.IntParam;
import ca.nanometrics.naqs.config.IntRange;
import ca.nanometrics.naqs.config.SerialInStream;
import ca.nanometrics.naqs.config.SerialOutStream;
import ca.nanometrics.naqs.config.Serialisable;
import ca.nanometrics.naqs.config.SerialiseException;
import ca.nanometrics.naqs.config.StringParam;
import ca.nanometrics.naqs.config.StringRange;
import ca.nanometrics.naqs.config.UpdateException;
import ca.nanometrics.naqs.config.UpdateMode;
import ca.nanometrics.naqs.config.UpdateResult;
import ca.nanometrics.util.SimpleParser;
import java.io.IOException;

public class NaqsAlertSenderConfig
implements Serialisable,
AlertSenderConfig {
    static final int ALERT_PORT = 31000;
    private StringRange namelen = new StringRange(1, 256);
    private IntRange portRange;
    private StringParam inetHost = new StringParam("Host", "localhost", 18, this.namelen);
    private IntParam inetPort;
    private StringParam sourceId = new StringParam("Source", "Naqs", 18, this.namelen);

    public NaqsAlertSenderConfig() {
        this.portRange = new IntRange(10, Short.MAX_VALUE);
        this.inetPort = new IntParam("Port", 31000, 18, this.portRange);
    }

    public void update(NaqsAlertSenderConfig newConfig, UpdateMode mode, UpdateResult result) {
        try {
            this.inetPort.putValue(newConfig.getInetPort(), mode);
        }
        catch (UpdateException ue) {
            result.postException(this, ue);
        }
    }

    public String getInetHost() {
        return this.inetHost.getValue();
    }

    public int getInetPort() {
        return this.inetPort.getValue();
    }

    public String getSourceId() {
        return this.sourceId.getValue();
    }

    public void saveGuts(SerialOutStream strm) throws SerialiseException {
        strm.serialiseObject(this.namelen);
        strm.serialiseObject(this.portRange);
        this.inetHost.saveGuts(strm);
        this.inetPort.saveGuts(strm);
        this.sourceId.saveGuts(strm);
    }

    public void restoreGuts(SerialInStream strm) throws SerialiseException {
        strm.deserialiseObject(this.namelen);
        strm.deserialiseObject(this.portRange);
        this.inetHost.restoreGuts(strm);
        this.inetPort.restoreGuts(strm);
        this.sourceId.restoreGuts(strm);
    }

    public void load(SimpleParser input) throws IOException {
        input.getHeader("AlertSender");
        this.inetHost.putValue(input.readString("InetHost"));
        this.inetPort.putValue(input.readInt("Port"));
        this.sourceId.putValue(input.readString("SourceId"));
    }
}

