/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.acq.fir.FilterException;
import ca.nanometrics.packet.DataPacket;
import ca.nanometrics.packet.DecompDataHandler;
import ca.nanometrics.packet.DecompDataPacket;
import ca.nanometrics.packet.NmxPacket;
import ca.nanometrics.packet.NmxPacketHandler;

public class NaqsFirFilter
implements NmxPacketHandler,
DecompDataHandler {
    private int key;
    private DecompDataHandler handler;
    private int filterOrder;
    private double[] filterCoeff;
    private int inputSampleRate;
    private int decimation;
    private int outputSampleRate;
    private double filterDelay;
    private int samplesPerPacket;
    private int samplesThisPacket;
    private int[] outputBuffer;
    private int outputCount;
    private int[] inputSamples;
    private double inputStartTime = 0.0;
    private long inputTotal = 0L;
    private double outputStartTime = 0.0;
    private long outputTotal = 0L;
    private int numSavedSamples;
    private boolean initialized = false;

    public NaqsFirFilter(int channelKey, DecompDataHandler outputHandler, double[] filterCoeffs, int filterDecimation, int outputPacketDuration, int sampleRate) throws FilterException {
        this.key = channelKey;
        this.handler = outputHandler;
        this.filterCoeff = (double[])filterCoeffs.clone();
        this.filterOrder = this.filterCoeff.length;
        this.decimation = filterDecimation;
        this.inputSampleRate = sampleRate;
        this.outputSampleRate = this.inputSampleRate / this.decimation;
        if (this.outputSampleRate * this.decimation != this.inputSampleRate) {
            throw new FilterException("output sample rate must be integer");
        }
        this.filterDelay = 0.5 * ((double)this.filterOrder - 1.0) / (double)this.inputSampleRate;
        this.samplesPerPacket = outputPacketDuration * this.outputSampleRate;
        this.outputBuffer = new int[this.samplesPerPacket];
        this.outputCount = 0;
        this.inputSamples = new int[0];
        this.numSavedSamples = 0;
    }

    public void put(DecompDataPacket dp) {
        if (this.key == dp.getKey()) {
            this.process(dp.getStartTime(), dp.getSamples(), dp.getSampleRate());
        }
    }

    public void put(NmxPacket p) {
        DataPacket dp;
        if (p instanceof DataPacket && this.key == (dp = (DataPacket)p).getKey()) {
            this.process(dp.getStartTime(), dp.getSamples(), dp.getSampleRate());
        }
    }

    private void process(double pktStartTime, int[] pktSamples, int pktSampleRate) {
        double nextPacketTime;
        if (this.initialized && Math.abs((double)this.inputSampleRate * (pktStartTime - (nextPacketTime = this.inputStartTime + (double)this.inputTotal / (double)this.inputSampleRate))) > 0.5) {
            this.sendCurrentPacket();
            this.initialized = false;
        }
        int firstInputSample = 0;
        if (!this.initialized) {
            firstInputSample = this.alignInput(pktStartTime);
            if (firstInputSample >= pktSamples.length) {
                return;
            }
            this.inputStartTime = pktStartTime;
            this.inputTotal = 0L;
            this.numSavedSamples = 0;
            this.outputStartTime = pktStartTime + (double)firstInputSample / (double)this.inputSampleRate + this.filterDelay;
            this.outputCount = 0;
            this.outputTotal = 0L;
            this.outputBuffer = new int[this.samplesThisPacket];
            this.initialized = true;
        }
        int numSamples = this.numSavedSamples + pktSamples.length - firstInputSample;
        int[] newSamples = new int[numSamples];
        System.arraycopy(this.inputSamples, this.inputSamples.length - this.numSavedSamples, newSamples, 0, this.numSavedSamples);
        System.arraycopy(pktSamples, firstInputSample, newSamples, this.numSavedSamples, pktSamples.length - firstInputSample);
        this.inputSamples = newSamples;
        int startIndex = 0;
        while (startIndex + this.filterOrder <= numSamples) {
            double sum = 0.0;
            int ix = 0;
            while (ix < this.filterOrder) {
                sum += (double)this.inputSamples[startIndex + ix] * this.filterCoeff[ix];
                ++ix;
            }
            this.outputBuffer[this.outputCount] = (int)Math.round(sum);
            ++this.outputCount;
            startIndex += this.decimation;
            if (this.outputCount != this.samplesThisPacket) continue;
            this.sendCurrentPacket();
        }
        this.inputTotal += (long)pktSamples.length;
        this.numSavedSamples = numSamples - startIndex;
    }

    private void sendCurrentPacket() {
        if (this.outputCount != 0) {
            double outputPacketTime = this.outputStartTime + (double)this.outputTotal / (double)this.outputSampleRate;
            DecompDataPacket outputPacket = new DecompDataPacket(this.key, outputPacketTime, this.outputBuffer, this.outputCount, this.outputSampleRate);
            this.handler.put(outputPacket);
            this.outputTotal += (long)this.outputCount;
            this.outputCount = 0;
            this.samplesThisPacket = this.samplesPerPacket;
            this.outputBuffer = new int[this.samplesThisPacket];
        }
    }

    private int alignInput(double pktTime) {
        double firstOut = pktTime + this.filterDelay;
        double deltat = firstOut - Math.floor(firstOut);
        double sampInDelta = (int)((deltat + 5.0E-5) * (double)this.inputSampleRate);
        double firstFrac = deltat - sampInDelta / (double)this.inputSampleRate;
        double sampleTime = Math.ceil(pktTime) + firstFrac + Math.ceil(this.filterDelay) - this.filterDelay;
        int sampleIndex = (int)Math.round((sampleTime - pktTime) * (double)this.inputSampleRate);
        this.samplesThisPacket = (sampleIndex %= this.inputSampleRate) / this.decimation;
        if (this.samplesThisPacket < 1) {
            this.samplesThisPacket = this.samplesPerPacket;
        }
        return sampleIndex %= this.decimation;
    }

    public String toString() {
        return "FirFilter " + this.filterOrder + " " + this.decimation + " " + this.inputSampleRate + " " + this.samplesPerPacket;
    }
}

