/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.naqs.config.IntEnum;
import ca.nanometrics.naqs.config.IntParam;
import ca.nanometrics.naqs.config.SerialInStream;
import ca.nanometrics.naqs.config.SerialOutStream;
import ca.nanometrics.naqs.config.Serialisable;
import ca.nanometrics.naqs.config.SerialiseException;
import ca.nanometrics.naqs.config.StringParam;
import ca.nanometrics.naqs.config.StringRange;
import ca.nanometrics.naqs.config.UpdateException;
import ca.nanometrics.naqs.config.UpdateMode;
import ca.nanometrics.naqs.config.UpdateResult;
import ca.nanometrics.util.SimpleParser;
import java.io.IOException;

public class NaqsLogConfig
implements Serialisable {
    private StringRange namelen = new StringRange(1, 128);
    private StringParam pathname = new StringParam("Log Directory", "data", 18, this.namelen);
    private StringParam filename = new StringParam("Log File", "Naqs.log", 18, this.namelen);
    private IntEnum verbEnum = new IntEnum(verbStrings);
    private IntParam verbosity = new IntParam("Verbosity", 2, 18, this.verbEnum);
    static final String[] verbStrings = new String[]{"Debug", "Verbose", "Info"};

    public void update(NaqsLogConfig newConfig, UpdateMode mode, UpdateResult result) {
        try {
            this.pathname.putValue(newConfig.getPathname(), mode);
        }
        catch (UpdateException ue) {
            result.postException(this, ue);
        }
        try {
            this.filename.putValue(newConfig.getFilename(), mode);
        }
        catch (UpdateException ue) {
            result.postException(this, ue);
        }
        try {
            this.verbosity.putValue(newConfig.getVerbosity(), mode);
        }
        catch (UpdateException ue) {
            result.postException(this, ue);
        }
    }

    public String getPathname() {
        return this.pathname.getValue();
    }

    public String getFilename() {
        return this.filename.getValue();
    }

    public int getVerbosity() {
        return this.verbosity.getValue();
    }

    public void setPathname(String name) {
        this.pathname.putValue(name);
    }

    public void setFilename(String name) {
        this.filename.putValue(name);
    }

    public void setVerbosity(int val) {
        this.verbosity.putValue(val);
    }

    public void setVerbosity(String val) {
        this.verbosity.putValue(val);
    }

    public void saveGuts(SerialOutStream strm) throws SerialiseException {
        strm.serialiseObject(this.namelen);
        strm.serialiseObject(this.verbEnum);
        this.pathname.saveGuts(strm);
        this.filename.saveGuts(strm);
        this.verbosity.saveGuts(strm);
    }

    public void restoreGuts(SerialInStream strm) throws SerialiseException {
        strm.deserialiseObject(this.namelen);
        strm.deserialiseObject(this.verbEnum);
        this.pathname.restoreGuts(strm);
        this.filename.restoreGuts(strm);
        this.verbosity.restoreGuts(strm);
    }

    public void load(SimpleParser input) throws IOException {
        input.getHeader("NaqsLog");
        this.setPathname(input.readString("LogPath"));
        this.setFilename(input.readString("LogFile"));
        this.setVerbosity(input.readString("Verbosity"));
    }
}

