/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.acq.Watchdog;
import ca.nanometrics.alert.Alert;
import ca.nanometrics.alert.AlertSender;
import ca.nanometrics.naqs.stndb.SimpleStationDatabase;
import ca.nanometrics.naqs.stndb.StationDatabase;
import ca.nanometrics.util.ConsoleMonitor;
import ca.nanometrics.util.FileLog;
import ca.nanometrics.util.Log;
import ca.nanometrics.util.LoopRunner;
import ca.nanometrics.util.NmxDateFormat;
import ca.nanometrics.util.Runner;
import ca.nanometrics.util.Stoppable;
import ca.nanometrics.util.StringQueue;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.StringTokenizer;

public class NaqsServer
extends LoopRunner
implements Stoppable {
    static final String CONFIG_FILE = "Naqs.cfg";
    static final String INI_FILE = "Naqs.ini";
    static final String STNDB_FILE = "Naqs.stn";
    static final long MILLIS_PER_DAY = 86400000L;
    private NaqsServerConfig cfg;
    private StationDatabase stndb;
    private NaqsLog log;
    private long naqsStartTime;
    private long currentDate;
    private Watchdog wdg;
    private StringQueue console;
    private ActionMonitor actionMonitor;
    private boolean restart = false;
    private NetworkInterface networkInterface;
    private ArchiveManager archiveManager;
    private DetectionManager detectionManager;
    private EventAssociator associator;
    private SohMonitor sohMonitor;
    private DSServer dsServer;
    private HrdCommandManager hrdCommandMgr;
    private RemoteLogger remoteLogger;
    private AlertSender alertSender;

    private NaqsServer(NaqsServerConfig config, StationDatabase database) throws IOException {
        super("NaqsServer");
        this.cfg = config;
        this.stndb = database;
        this.naqsStartTime = System.currentTimeMillis();
        this.actionMonitor = new ActionMonitor("NaqsServer");
        this.currentDate = System.currentTimeMillis() / 86400000L;
        this.init();
    }

    private void init() throws IOException {
        this.log = new NaqsLog(this.cfg.getNaqsLogConfig());
        this.log.setSource(this.stndb.getNetworkTag());
        Log.installLog(this.log);
        this.writeBanner();
        this.wdg = Watchdog.getWatchdog();
        if (this.wdg.isOpen()) {
            Log.report(this, 1, 2, "Using software watchdog.");
        } else {
            Log.report(this, 2, 3, "Software watchdog not found.");
        }
        this.wdg.startShutdownMonitor(this);
        this.console = ConsoleMonitor.getInputQueue();
        this.alertSender = new AlertSender(this.cfg.getAlertSenderConfig());
        Alert.install(this.alertSender);
        this.networkInterface = new NetworkInterface(this.cfg.getNetworkInterfaceConfig(), this.stndb);
        this.archiveManager = new ArchiveManager(this.cfg.getArchiveManagerConfig(), this.stndb);
        this.detectionManager = new DetectionManager(this.cfg.getDetectionManagerConfig(), this.stndb);
        this.associator = new EventAssociator(this.cfg.getEventAssociatorConfig(), this.stndb);
        this.sohMonitor = new SohMonitor(this.cfg.getSohMonitorConfig());
        this.hrdCommandMgr = new HrdCommandManager(this.cfg.getCalibratorConfig(), this.stndb);
        this.dsServer = new DSServer(this.cfg.getDatastreamConfig(), this.stndb, this.archiveManager, this.hrdCommandMgr);
        this.remoteLogger = new RemoteLogger();
        this.networkInterface.addNmxSubscriber(this.archiveManager);
        this.networkInterface.addNmxSubscriber(this.remoteLogger);
        this.networkInterface.addNmxSubscriber(this.hrdCommandMgr);
        this.networkInterface.addCmdSubscriber(this.archiveManager);
        this.archiveManager.addNmxpSubscriber(this.detectionManager);
        this.archiveManager.addNmxpSubscriber(this.sohMonitor);
        this.archiveManager.addNmxpSubscriber(this.dsServer);
        this.archiveManager.setReTxHandler(this.networkInterface);
        this.hrdCommandMgr.setHandler(this.networkInterface);
        this.associator.addEventSubscriber(this.dsServer.getEventHandler());
        this.sohMonitor.addSohSubscriber(this.hrdCommandMgr);
        this.detectionManager.addTriggerSubscriber(this.associator);
        this.detectionManager.addTriggerSubscriber(this.dsServer.getTriggerHandler());
    }

    private void writeBanner() {
        Log.report(this, 0, 2, "*********************************************");
        Log.report(this, 0, 2, "* NaqsServer Data Acquisition System");
        Log.report(this, 0, 2, "*   version " + NaqsVersion.getVersion());
        Log.report(this, 0, 2, "* " + NaqsVersion.getCopyright());
        Log.report(this, 0, 2, "---------------------------------------------");
    }

    protected void open() {
        Log.report(this, 3, 2, "Starting subsystems...");
        this.alertSender.start();
        this.networkInterface.start();
        this.archiveManager.start();
        this.detectionManager.start();
        this.associator.start();
        this.sohMonitor.start();
        this.dsServer.start();
    }

    private void reportVersion() {
        Log.report(this, 0, 2, "NaqsServer version " + NaqsVersion.getVersion());
    }

    private long getUptimeSec() {
        return (System.currentTimeMillis() - this.naqsStartTime) / 1000L;
    }

    private void reportUptime() {
        long uptimeSec = this.getUptimeSec();
        long uptimeDays = uptimeSec / 86400L;
        NmxDateFormat df = new NmxDateFormat("HH:mm:ss");
        Log.report(this, 0, 2, "Uptime: " + uptimeDays + " days " + df.format(uptimeSec));
    }

    private void reportStatus(String hint) {
        if (hint.equals("SUMMARY") || hint.equals("ALL") || hint.equals("UPTIME")) {
            this.reportVersion();
            this.reportUptime();
        }
        this.networkInterface.reportStatus(hint);
        this.archiveManager.reportStatus(hint);
        this.detectionManager.reportStatus(hint);
        this.associator.reportStatus(hint);
        this.sohMonitor.reportStatus(hint);
        this.dsServer.reportStatus();
    }

    private void handleReportCommand(String input) {
        StringTokenizer stok = new StringTokenizer(input);
        String token = stok.nextToken();
        if (stok.hasMoreTokens()) {
            while (stok.hasMoreTokens()) {
                this.reportStatus(stok.nextToken());
            }
        } else {
            this.reportStatus("SUMMARY");
        }
    }

    private void handleResetCommand(String input) {
        StringTokenizer stok = new StringTokenizer(input);
        String token = stok.nextToken();
        if (stok.hasMoreTokens()) {
            while (stok.hasMoreTokens()) {
                this.archiveManager.resetStatus(stok.nextToken());
            }
        } else {
            this.archiveManager.resetStatus("CHANNELS");
        }
    }

    private void handleMonitorCommand(String input) {
        StringTokenizer stok = new StringTokenizer(input);
        String token = stok.nextToken();
        if (stok.hasMoreTokens()) {
            String channel = stok.nextToken();
            String interval = "ON";
            if (stok.hasMoreTokens()) {
                interval = stok.nextToken();
            }
            this.archiveManager.monitorChannels(channel, interval);
        } else {
            this.archiveManager.monitorChannels("CHANNELS", "ON");
        }
    }

    private void handleRetxCommand(String input) {
        StringTokenizer stok = new StringTokenizer(input);
        String token = stok.nextToken();
        boolean setRetx = false;
        if (stok.countTokens() > 0) {
            token = stok.nextToken();
            if (token.equals("ON")) {
                this.networkInterface.setRetxEnabled(true);
                setRetx = true;
            }
            if (token.equals("OFF")) {
                this.networkInterface.setRetxEnabled(false);
                setRetx = true;
            }
        }
        if (!setRetx) {
            Log.report(this, 0, 2, "ReTx request is " + (this.networkInterface.isRetxEnabled() ? "ON" : "OFF"));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean handleConsole() {
        try {
            while (true) {
                if (this.console.size() <= 0) {
                    return true;
                }
                String input = this.console.get(200);
                if (input == null) return true;
                if (input.length() == 0) {
                    return true;
                }
                if ((input = input.toUpperCase()).equals("QUIT") || input.equals("EXIT")) {
                    Log.report(this, 5, 2, "User exit.");
                    this.restart = false;
                    return false;
                }
                if (input.equals("RESTART")) {
                    Log.report(this, 5, 2, "User restart.");
                    this.restart = true;
                    return false;
                }
                if (input.startsWith("RETX")) {
                    this.handleRetxCommand(input);
                    continue;
                }
                if (input.startsWith("RESET")) {
                    this.handleResetCommand(input);
                    continue;
                }
                if (input.startsWith("REPORT")) {
                    this.handleReportCommand(input);
                    continue;
                }
                if (input.startsWith("MONITOR")) {
                    this.handleMonitorCommand(input);
                    continue;
                }
                if (input.equals("D")) {
                    this.log.setVerbosity(0);
                    continue;
                }
                if (input.equals("V")) {
                    this.log.setVerbosity(1);
                    continue;
                }
                if (input.equals("I")) {
                    this.log.setVerbosity(2);
                    continue;
                }
                if (input.equals("M")) {
                    this.log.move();
                    continue;
                }
                Log.report(this, 9, 3, "Invalid console input: " + input);
            }
        }
        catch (IOException e) {
            Log.report(this, 8, 4, "Error moving log file: " + e.getMessage());
            return true;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return true;
    }

    private boolean handleActionMonitor() {
        int action = this.actionMonitor.requiredAction();
        if (action == 2) {
            Log.report(this, 0, 2, "Shutdown via remote command");
            this.restart = false;
            return false;
        }
        if (action == 1) {
            Log.report(this, 0, 2, "Restart via remote command");
            this.restart = true;
            return false;
        }
        return true;
    }

    private void reportSummary() {
        this.reportVersion();
        this.reportUptime();
        this.networkInterface.reportSummary();
        this.detectionManager.reportSummary();
        this.associator.reportSummary();
        this.dsServer.reportSummary();
    }

    private void reportOnNewDate() {
        long newDate = System.currentTimeMillis() / 86400000L;
        if (newDate != this.currentDate) {
            this.currentDate = newDate;
            this.reportSummary();
            this.log.reopenOnNewDate();
            this.reportVersion();
        }
    }

    protected void body() {
        this.reportOnNewDate();
        this.stayAlive &= this.handleConsole() && this.handleActionMonitor();
        this.sleep(200L);
    }

    protected void tick() {
        if (this.isRunningOk()) {
            this.wdg.hitWatchdog();
        } else {
            Log.report(this, 6, 5, "Thread died... quitting.");
            this.restart = this.getUptimeSec() > 120L;
            this.stayAlive = false;
        }
    }

    protected void close() {
        Log.report(this, 7, 2, "Stopping all subsystems...");
        this.networkInterface.stop();
        this.archiveManager.stop();
        this.detectionManager.stop();
        this.associator.stop();
        this.sohMonitor.stop();
        this.dsServer.stop();
        this.alertSender.stop();
        this.reportSummary();
    }

    private boolean isRunningOk(boolean isOk, String name) {
        if (!isOk) {
            Log.report(this, 20, 4, String.valueOf(name) + "is not running OK");
        }
        return isOk;
    }

    private boolean isRunningOk(Runner runner, String name) {
        return this.isRunningOk(runner.isRunningOk(), name);
    }

    public boolean isRunningOk() {
        boolean isNetworkOk = this.networkInterface.isRunningOk();
        boolean isOk = true;
        isOk &= this.isRunningOk(this.alertSender, "AlertSender");
        isOk &= this.isRunningOk(isNetworkOk, "NetworkInterface");
        isOk &= this.isRunningOk(this.archiveManager, "ArchiveManager");
        isOk &= this.isRunningOk(this.detectionManager, "DetectionManager");
        isOk &= this.isRunningOk(this.sohMonitor, "SohMonitor");
        isOk &= this.isRunningOk(this.associator, "Associator");
        return isOk &= this.isRunningOk(this.dsServer, "DSServer");
    }

    private NaqsServerConfig getNewConfig() {
        return new NaqsServerConfig();
    }

    private static NaqsServerConfig loadIniFile(String[] args) throws IOException {
        String cfgSource = INI_FILE;
        if (args.length > 0) {
            cfgSource = args[0];
        }
        try {
            Log.report("NaqsInit", 1, 2, "loading config from " + cfgSource);
            NaqsServerConfig config = new NaqsServerConfig();
            config.load(cfgSource);
            return config;
        }
        catch (FileNotFoundException fnfe) {
            throw new IOException("NaqsServer ini file not found: " + cfgSource);
        }
        catch (IOException e) {
            throw new IOException("Error loading config: " + e.getMessage());
        }
    }

    private static StationDatabase loadStndb(String[] args) throws IOException {
        String stnSource = STNDB_FILE;
        if (args.length > 1) {
            stnSource = args[1];
        }
        try {
            Log.report("NaqsInit", 2, 2, "loading station database from " + stnSource);
            return new SimpleStationDatabase(stnSource);
        }
        catch (FileNotFoundException fnfe) {
            throw new IOException("Station database file not found: " + stnSource);
        }
        catch (IOException e) {
            throw new IOException("Error loading station database: " + e.getMessage());
        }
    }

    private static NaqsServer createApp(String[] args) throws IOException {
        NaqsServerConfig config = NaqsServer.loadIniFile(args);
        StationDatabase stndb = NaqsServer.loadStndb(args);
        return new NaqsServer(config, stndb);
    }

    private static void finalizeOnExit() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.gc();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.gc();
        System.runFinalization();
    }

    public static void main(String[] args) {
        try {
            Log.installLog(new FileLog("NaqsInit.log"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            boolean keepRunning = true;
            while (keepRunning) {
                NaqsServer naqs = NaqsServer.createApp(args);
                naqs.start();
                naqs.join();
                keepRunning = naqs.restart;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.report("NaqsInit", 3, 5, e.toString());
        }
        NaqsServer.finalizeOnExit();
        System.exit(0);
    }
}

