/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.naqs.config.UpdateMode;
import ca.nanometrics.naqs.config.UpdateResult;
import ca.nanometrics.naqs.stndb.StationDatabase;
import ca.nanometrics.net.PersistentMulticastSocket;
import ca.nanometrics.packet.DoDRequestPacket;
import ca.nanometrics.packet.HrdCommandDistributor;
import ca.nanometrics.packet.HrdCommandHandler;
import ca.nanometrics.packet.HrdCommandPacket;
import ca.nanometrics.packet.NmxPacketDistributor;
import ca.nanometrics.packet.NmxPacketHandler;
import ca.nanometrics.util.Log;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.Enumeration;

public class NetworkInterface
implements HrdCommandHandler {
    private static final String RATFILE = "naqsaddr.ini";
    private NetworkInterfaceConfig cfg;
    MulticastSocket ds = null;
    PacketReceiver receiver = null;
    PacketSender sender = null;
    private ReturnAddressTable rat;
    NmxPacketDistributor nph = new NmxPacketDistributor();
    HrdCommandDistributor hch = new HrdCommandDistributor();

    public NetworkInterface(NetworkInterfaceConfig config, StationDatabase stndb) throws IOException {
        this.cfg = config;
        this.rat = new ReturnAddressTable(stndb, RATFILE);
        try {
            this.ds = new PersistentMulticastSocket(this.cfg.getPort(), 30000, true);
            this.ds.setSoTimeout(500);
            this.ds.setReceiveBufferSize(128000);
            this.joinMulticastGroups(this.cfg.getMcastGroups());
            this.receiver = new PacketReceiver(this.ds, this.nph, this.hch, this.rat);
            this.sender = new PacketSender(this.ds, this.rat);
            this.sender.setSendDelay(this.cfg.getSendDelay());
            this.sender.setRetxEnabled(this.cfg.isRetxEnabled());
        }
        catch (IOException e) {
            Log.report(this, 1, 5, "Cannot open datagram socket.");
            throw e;
        }
    }

    private void joinGroup(String mcastGroup) {
        try {
            this.ds.joinGroup(InetAddress.getByName(mcastGroup));
            Log.report(this, 3, 2, "Receiving on multicast group " + mcastGroup);
        }
        catch (Exception exc) {
            Log.report(this, 4, 3, "Cannot join multicast group " + mcastGroup);
        }
    }

    private void joinMulticastGroups(Enumeration groups) {
        while (groups.hasMoreElements()) {
            String group = groups.nextElement().toString();
            this.joinGroup(group);
        }
    }

    public void start() {
        this.receiver.start();
        this.sender.start();
    }

    public void stop() {
        this.receiver.stop();
        this.sender.stop();
        if (this.ds != null) {
            this.ds.close();
        }
    }

    public boolean isRunningOk() {
        return this.receiver.isRunningOk() && this.sender.isRunningOk();
    }

    public void update(NetworkInterfaceConfig newConfig, UpdateMode mode, UpdateResult result) {
    }

    public void put(HrdCommandPacket packet) {
        if (packet instanceof DoDRequestPacket) {
            this.hch.put(packet);
        }
        this.sender.put(packet);
    }

    public boolean isRetxEnabled() {
        return this.sender.isRetxEnabled();
    }

    public void setRetxEnabled(boolean enabled) {
        this.sender.setRetxEnabled(enabled);
    }

    public void addNmxSubscriber(NmxPacketHandler subscriber) {
        this.nph.addSubscriber(subscriber);
    }

    public void removeNmxSubscriber(NmxPacketHandler subscriber) {
        this.nph.removeSubscriber(subscriber);
    }

    public void addCmdSubscriber(HrdCommandHandler subscriber) {
        this.hch.addSubscriber(subscriber);
    }

    public void removeCmdSubscriber(HrdCommandHandler subscriber) {
        this.hch.removeSubscriber(subscriber);
    }

    public void reportStatus(String hint) {
        this.receiver.reportStatus(hint);
        this.sender.reportStatus(hint);
    }

    public void reportSummary() {
        this.receiver.reportSummary();
        this.sender.reportSummary();
    }
}

