/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.naqs.config.BoolEnum;
import ca.nanometrics.naqs.config.BoolParam;
import ca.nanometrics.naqs.config.IntParam;
import ca.nanometrics.naqs.config.IntRange;
import ca.nanometrics.naqs.config.SerialInStream;
import ca.nanometrics.naqs.config.SerialOutStream;
import ca.nanometrics.naqs.config.Serialisable;
import ca.nanometrics.naqs.config.SerialiseException;
import ca.nanometrics.naqs.config.UpdateException;
import ca.nanometrics.naqs.config.UpdateMode;
import ca.nanometrics.naqs.config.UpdateResult;
import ca.nanometrics.util.SimpleParser;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class NetworkInterfaceConfig
implements Serialisable {
    static final int NAQS_PORT = 32000;
    private IntRange portRange = new IntRange(10, Short.MAX_VALUE);
    private IntParam port = new IntParam("Port", 32000, 18, this.portRange);
    private IntRange delayRange = new IntRange(0, 1000);
    private IntParam sendDelay = new IntParam("Delay", 0, 18, this.delayRange);
    private BoolEnum retxChoices = new BoolEnum("Enabled", "Disabled");
    private BoolParam retxEnabled = new BoolParam("ReTx", true, 0, this.retxChoices);
    private Vector mcastGroups = new Vector();

    public void update(NetworkInterfaceConfig newConfig, UpdateMode mode, UpdateResult result) {
        try {
            this.port.putValue(newConfig.getPort(), mode);
        }
        catch (UpdateException ue) {
            result.postException(this, ue);
        }
    }

    public int getPort() {
        return this.port.getValue();
    }

    public int getSendDelay() {
        return this.sendDelay.getValue();
    }

    public boolean isRetxEnabled() {
        return this.retxEnabled.getValue();
    }

    public void setPort(int portVal) {
        this.port.putValue(portVal);
    }

    public void setSendDelay(int millis) {
        this.sendDelay.putValue(millis);
    }

    public void setRetxEnabled(boolean enabled) {
        this.retxEnabled.putValue(enabled);
    }

    public Enumeration getMcastGroups() {
        return this.mcastGroups.elements();
    }

    public void saveGuts(SerialOutStream strm) throws SerialiseException {
        strm.serialiseObject(this.portRange);
        strm.serialiseObject(this.delayRange);
        strm.serialiseObject(this.retxChoices);
        this.port.saveGuts(strm);
        this.sendDelay.saveGuts(strm);
        this.retxEnabled.saveGuts(strm);
    }

    public void restoreGuts(SerialInStream strm) throws SerialiseException {
        strm.deserialiseObject(this.portRange);
        strm.deserialiseObject(this.delayRange);
        strm.deserialiseObject(this.retxChoices);
        this.port.restoreGuts(strm);
        this.sendDelay.restoreGuts(strm);
        this.retxEnabled.restoreGuts(strm);
    }

    public void load(SimpleParser input) throws IOException {
        input.getHeader("NetworkInterface");
        this.setPort(input.readInt("Port"));
        this.setSendDelay(input.readInt("SendDelay"));
        if (input.isNextLineParam("RetxRequest")) {
            this.retxEnabled.putValue(input.readString("RetxRequest"));
        }
        while (input.isNextLineParam("MulticastGroup")) {
            this.mcastGroups.addElement(input.readString("MulticastGroup"));
        }
    }
}

