/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.packet.NmxPacket;
import ca.nanometrics.packet.NmxPacketBuffer;
import ca.nanometrics.packet.NmxPacketHandler;
import java.util.Hashtable;

public class NmxBufferTable
implements NmxPacketHandler {
    private Hashtable table = new Hashtable();
    private int capacity = 0;

    public NmxBufferTable(int bufferSize) {
        this.capacity = bufferSize > 0 ? bufferSize : 0;
    }

    private NmxPacketBuffer addBuffer(int key, NmxPacketBuffer buffer) {
        return this.table.put(new Integer(key), buffer);
    }

    private NmxPacketBuffer getBuffer(int key) {
        return (NmxPacketBuffer)this.table.get(new Integer(key));
    }

    public void remove(int key) {
        this.table.remove(new Integer(key));
    }

    public void clear() {
        this.table.clear();
    }

    public void put(NmxPacket pkt) {
        if (this.capacity > 0) {
            int key = pkt.getKey();
            NmxPacketBuffer buffer = this.getBuffer(key);
            if (buffer == null) {
                this.addBuffer(key, new NmxPacketBuffer(this.capacity));
                buffer = this.getBuffer(key);
            }
            if (buffer != null) {
                buffer.put(pkt);
            }
        }
    }

    public void sendTo(NmxPacketHandler handler, int key) {
        NmxPacketBuffer buffer = this.getBuffer(key);
        if (buffer != null) {
            buffer.sendTo(handler);
        }
    }
}

