/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.packet.HrdCommandFactory;
import ca.nanometrics.packet.HrdCommandHandler;
import ca.nanometrics.packet.HrdCommandPacket;
import ca.nanometrics.packet.InternetPacketWrapper;
import ca.nanometrics.packet.NmxPacket;
import ca.nanometrics.packet.NmxPacketFactory;
import ca.nanometrics.packet.NmxPacketHandler;
import ca.nanometrics.packet.PacketWrapper;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.util.Log;
import ca.nanometrics.util.NmxDateFormat;
import ca.nanometrics.util.Runner;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;

public class PacketReceiver
extends Runner {
    static final int RX_BUFFER_SIZE = 512;
    static final int WDG_LOOP_TIMEOUT = 60;
    static final long MILLIS_PER_DAY = 86400000L;
    int bufferSize = 512;
    NmxPacketHandler pktHandler;
    HrdCommandHandler retxHandler;
    ReturnAddressTable rat;
    DatagramSocket ds;
    PacketWrapper pw = new InternetPacketWrapper();
    private String lastReportTime;
    private int rxCount;
    private NmxDateFormat dateFormat = new NmxDateFormat("yyyy/MM/dd_HH:mm:ss");

    public PacketReceiver(DatagramSocket socket, NmxPacketHandler npHandler, HrdCommandHandler hcHandler, ReturnAddressTable raTable) throws SocketException {
        super("PacketReceiver");
        this.ds = socket;
        this.pktHandler = npHandler;
        this.retxHandler = hcHandler;
        this.rat = raTable;
        this.resetStatus();
    }

    public synchronized void setSocket(DatagramSocket socket) {
        this.ds = socket;
    }

    public synchronized void receive(DatagramPacket dp) throws IOException {
        this.ds.receive(dp);
    }

    private void reportRxError(int errnum, DatagramPacket dp, byte[] wpkt) {
        Log.report(this, errnum, 2, "invalid packet type = " + this.pw.getDataType(wpkt) + ", len = " + dp.getLength() + ", datalen = " + this.pw.getDataLength(wpkt) + " from " + dp.getAddress().getHostAddress());
    }

    protected void handleNmxPacket(byte[] wpkt, DatagramPacket dp) {
        try {
            NmxPacket packet = NmxPacketFactory.makePacket(wpkt, this.pw.getDataOffset(), this.pw.getDataLength(wpkt));
            if (packet != null) {
                ++this.rxCount;
                Log.report(this, 4, 0, "Received " + (packet.isReTx() ? "R " : "") + packet);
                this.rat.updateReturnAddress(packet.getInstrumentID(), dp.getAddress(), dp.getPort());
                this.pktHandler.put(packet);
            }
        }
        catch (InvalidInputException e) {
            Log.report(this, 5, 2, "Rx exception: " + e.getMessage());
        }
    }

    protected void handleHrdCommand(byte[] wpkt) {
        try {
            HrdCommandPacket packet = HrdCommandFactory.makePacket(wpkt, this.pw.getDataOffset(), this.pw.getDataLength(wpkt));
            if (packet != null) {
                Log.report(this, 4, 0, "Received " + packet);
                this.retxHandler.put(packet);
            }
        }
        catch (InvalidInputException e) {
            Log.report(this, 5, 2, "Rx exception: " + e.getMessage());
        }
    }

    public void runbody() throws IOException {
        byte[] buffer = new byte[this.bufferSize];
        DatagramPacket dp = new DatagramPacket(buffer, buffer.length);
        this.receive(dp);
        byte[] wpkt = dp.getData();
        if (this.stayAlive && dp.getAddress() != null) {
            if (this.pw.isValidPacket(wpkt, dp.getLength())) {
                if (this.pw.getDataType(wpkt) == 1) {
                    this.handleNmxPacket(wpkt, dp);
                } else if (this.pw.getDataType(wpkt) == 2) {
                    this.handleHrdCommand(wpkt);
                } else {
                    this.reportRxError(6, dp, wpkt);
                }
            } else {
                this.reportRxError(7, dp, wpkt);
            }
        }
    }

    public void run() {
        this.setPriority(10);
        Log.report(this, 2, 2, "starting with priority " + this.getPriority());
        while (this.stayAlive) {
            this.setWdgTimeout(60);
            try {
                this.runbody();
            }
            catch (InterruptedIOException interruptedIOException) {
            }
            catch (IOException e) {
                Log.report(this, 8, 3, e.getMessage());
            }
            catch (Exception e) {
                Log.report(this, 8, 3, e.toString());
            }
        }
        Log.report(this, 3, 1, "quitting...");
    }

    protected void reportStatus() {
        Log.report(this, 0, 2, "Packets recd since " + this.lastReportTime + ": " + this.rxCount);
    }

    public void reportStatus(String hint) {
        if (hint.equals("RX") || hint.equals("ALL") || hint.equals("SUMMARY")) {
            this.reportStatus();
        }
    }

    protected void resetStatus() {
        this.lastReportTime = this.dateFormat.format(System.currentTimeMillis() / 1000L);
        this.rxCount = 0;
    }

    public synchronized void reportSummary() {
        this.reportStatus();
        this.resetStatus();
    }
}

