/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.alert.Alert;
import ca.nanometrics.naqs.stndb.ChannelConfig;
import ca.nanometrics.naqs.stndb.StationDatabase;
import ca.nanometrics.packet.Instrument;
import ca.nanometrics.packet.NmxPacket;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;

public class PacketRxMonitor {
    public static final int MS_PER_SEC = 1000;
    public static final int MS_PER_MIN = 60000;
    public static final int MS_PER_HOUR = 3600000;
    public static final int MS_PER_DAY = 86400000;
    public static final String blanks = "     ";
    public static final int DEFAULT_STARTUP_TIMEOUT = 120;
    public static final int RX_TIMEOUT = 600;
    public static final int MIN_GROUP_DELAY = 10;
    public static final int MAX_GROUP_DELAY = 60;
    public static final int PING_INTERVAL = 30;
    private Hashtable table = new Hashtable();
    private Set monitors = new TreeSet();
    private int ticksToStartAlert;
    private int ticksToNextPing = 30;
    private long startTime;
    private long lastReportTime = this.startTime = System.currentTimeMillis();
    private long lastStatusTime = this.startTime;
    private long reportInterval = 86400000L;
    private int packetsReceived = 0;
    private int retxReceived = 0;
    private GroupMonitor recentOffline;
    private GroupMonitor recentOnline;

    public PacketRxMonitor(StationDatabase stndb, int startupTimeout) {
        this.createMonitors(stndb);
        this.ticksToStartAlert = startupTimeout > 0 ? startupTimeout : 0;
        this.recentOffline = new GroupMonitor(10, 60);
        this.recentOnline = new GroupMonitor(10, 60);
    }

    public PacketRxMonitor(StationDatabase stndb) {
        this(stndb, 120);
    }

    private String pad(int width) {
        if (width >= blanks.length()) {
            return "";
        }
        if (width < 0) {
            width = 0;
        }
        return blanks.substring(width);
    }

    private void createMonitors(StationDatabase stndb) {
        Iterator channels = stndb.getChannels().iterator();
        while (channels.hasNext()) {
            ChannelConfig chan;
            int id;
            Integer key;
            Object object = channels.next();
            if (object == null || !(object instanceof ChannelConfig) || this.table.containsKey(key = new Integer(id = (chan = (ChannelConfig)object).getInstrumentID()))) continue;
            String station = chan.getStationName();
            String name = String.valueOf(station) + ": " + this.pad(station.length()) + Instrument.getNameOf(id);
            StateMonitor monitor = new StateMonitor(name, 600);
            this.table.put(key, monitor);
            this.monitors.add(monitor);
        }
    }

    protected void ping(int id, boolean retx) {
        StateMonitor monitor = (StateMonitor)this.table.get(new Integer(id));
        if (monitor != null) {
            int prevState;
            ++this.packetsReceived;
            if (retx) {
                ++this.retxReceived;
            }
            if ((prevState = monitor.ping()) != 0 && this.ticksToStartAlert == 0) {
                this.recentOnline.add(monitor);
                this.recentOffline.remove(monitor);
            }
        }
    }

    public void processPacket(NmxPacket packet) {
        this.ping(packet.getInstrumentID(), packet.isReTx());
    }

    private String stationList(Set stns) {
        int maxToShow = 20;
        int numToShow = 18;
        int numStns = stns.size();
        if (numStns <= maxToShow) {
            numToShow = numStns;
        }
        if (numToShow < 1) {
            return "\n<none>";
        }
        StringBuffer sb = new StringBuffer();
        int count = 0;
        Iterator iter = stns.iterator();
        while (iter.hasNext() && count < numToShow) {
            StateMonitor monitor = (StateMonitor)iter.next();
            sb.append("\n" + monitor.getName());
            ++count;
        }
        if (count < numStns) {
            sb.append("\nand " + (numStns - count) + " others.");
        }
        return sb.toString();
    }

    private int reportCurrentStatus(StringBuffer format, StringBuffer args, int argnum) {
        TreeSet<StateMonitor> offline = new TreeSet<StateMonitor>();
        TreeSet<StateMonitor> online = new TreeSet<StateMonitor>();
        Iterator iter = this.monitors.iterator();
        while (iter.hasNext()) {
            StateMonitor monitor = (StateMonitor)iter.next();
            if (monitor.isOnline()) {
                online.add(monitor);
                continue;
            }
            offline.add(monitor);
        }
        format.append("Currently receiving from %" + argnum++);
        format.append(" / %" + argnum++ + " instruments.\n");
        format.append("The following instruments are online: %" + argnum++ + "\n");
        format.append("The following instruments are offline: %" + argnum++ + "\n");
        args.append("/" + online.size());
        args.append("/" + (online.size() + offline.size()));
        args.append("/" + this.stationList(online));
        args.append("/" + this.stationList(offline));
        return argnum;
    }

    public void reportOffline() {
        StringBuffer format = new StringBuffer(80);
        format.append("NaqsServer has stopped receiving from %1\n");
        StringBuffer args = new StringBuffer(80);
        args.append("/" + this.stationList(this.recentOffline.getMonitors()));
        this.reportCurrentStatus(format, args, 2);
        Alert.report("InstrumentOffline", 10, format.toString(), args.toString());
    }

    public void reportOnline() {
        StringBuffer format = new StringBuffer(80);
        format.append("NaqsServer has started receiving from %1\n");
        StringBuffer args = new StringBuffer(80);
        args.append("/" + this.stationList(this.recentOnline.getMonitors()));
        this.reportCurrentStatus(format, args, 2);
        Alert.report("InstrumentOnline", 10, format.toString(), args.toString());
    }

    public void reportNaqsStatus() {
        StringBuffer format = new StringBuffer(80);
        format.append("NaqsServer hourly status report.\n");
        StringBuffer args = new StringBuffer(80);
        this.reportCurrentStatus(format, args, 1);
        Alert.report("NaqsStatus", 1, format.toString(), args.toString());
    }

    protected void reportStartup() {
        StringBuffer format = new StringBuffer(80);
        format.append("NaqsServer is now running.\n");
        StringBuffer args = new StringBuffer(80);
        this.reportCurrentStatus(format, args, 1);
        Alert.report("NaqsAlive", 1, format.toString(), args.toString());
    }

    protected double getReTxPercent() {
        if (this.packetsReceived > 0) {
            return 0.01 * (double)Math.round(10000.0 * (double)this.retxReceived / (double)this.packetsReceived);
        }
        return 0.0;
    }

    protected String getUptime() {
        long uptime = System.currentTimeMillis() - this.startTime;
        if (uptime < 0L) {
            uptime = 0L;
        }
        int days = (int)(uptime / 86400000L);
        int hours = (int)(uptime / 3600000L % 24L);
        int mins = (int)(uptime / 60000L % 60L);
        int secs = (int)(uptime / 1000L % 60L);
        return days + "d " + hours + "h " + mins + "m " + secs + "s";
    }

    public void reportNaqsReport() {
        TreeSet<StateMonitor> offline = new TreeSet<StateMonitor>();
        TreeSet<StateMonitor> online = new TreeSet<StateMonitor>();
        Iterator iter = this.monitors.iterator();
        while (iter.hasNext()) {
            StateMonitor monitor = (StateMonitor)iter.next();
            if (monitor.isLatched()) {
                online.add(monitor);
                continue;
            }
            offline.add(monitor);
        }
        StringBuffer format = new StringBuffer(80);
        format.append("NaqsServer daily status report.\n");
        format.append("Uptime:  %1\n");
        format.append("Packets received today: %2 (retx %3 %%)\n");
        format.append("Received data from %4 / %5 instruments.\n");
        format.append("Received data from the following instruments: %6\n");
        format.append("The following instruments remained offline: %7\n");
        StringBuffer args = new StringBuffer(80);
        args.append("/" + this.getUptime());
        args.append("/" + this.packetsReceived);
        args.append("/" + this.getReTxPercent());
        args.append("/" + online.size());
        args.append("/" + (online.size() + offline.size()));
        args.append("/" + this.stationList(online));
        args.append("/" + this.stationList(offline));
        Alert.report("NaqsReport", 1, format.toString(), args.toString());
    }

    protected int countOnlineMonitors() {
        int count = 0;
        Iterator iter = this.monitors.iterator();
        while (iter.hasNext()) {
            StateMonitor monitor = (StateMonitor)iter.next();
            if (!monitor.isOnline()) continue;
            ++count;
        }
        return count;
    }

    protected void reset() {
        Iterator iter = this.monitors.iterator();
        while (iter.hasNext()) {
            StateMonitor monitor = (StateMonitor)iter.next();
            monitor.reset();
        }
        this.packetsReceived = 0;
        this.retxReceived = 0;
    }

    public void test() {
        long currentTime = System.currentTimeMillis();
        Iterator iter = this.monitors.iterator();
        while (iter.hasNext()) {
            StateMonitor monitor = (StateMonitor)iter.next();
            int prevState = monitor.test();
            if (prevState == monitor.getState() || this.ticksToStartAlert != 0) continue;
            this.recentOffline.add(monitor);
            this.recentOnline.remove(monitor);
        }
        if (--this.ticksToNextPing <= 0) {
            this.ticksToNextPing = 30;
            Alert.report("ping", 1, "ping");
        }
        if (this.ticksToStartAlert > 0) {
            --this.ticksToStartAlert;
            if (this.ticksToStartAlert == 0 || this.countOnlineMonitors() == this.monitors.size()) {
                this.reportStartup();
                this.ticksToStartAlert = 0;
            }
        } else {
            if (this.recentOffline.test()) {
                this.reportOffline();
                this.recentOffline.clear();
            }
            if (this.recentOnline.test()) {
                this.reportOnline();
                this.recentOnline.clear();
            }
            if (currentTime / 3600000L != this.lastStatusTime / 3600000L) {
                this.reportNaqsStatus();
                this.lastStatusTime = currentTime;
            }
            if (currentTime / this.reportInterval != this.lastReportTime / this.reportInterval) {
                this.reportNaqsReport();
                this.lastReportTime = currentTime;
                this.reset();
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("monitors:\n");
        Iterator iter = this.monitors.iterator();
        while (iter.hasNext()) {
            sb.append(String.valueOf(iter.next().toString()) + "\n");
        }
        return sb.toString();
    }
}

