/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.packet.HrdCommandHandler;
import ca.nanometrics.packet.HrdCommandPacket;
import ca.nanometrics.packet.InternetPacketWrapper;
import ca.nanometrics.packet.PacketWrapper;
import ca.nanometrics.packet.ReTxRequestPacket;
import ca.nanometrics.util.BufferedConsumer;
import ca.nanometrics.util.Log;
import ca.nanometrics.util.NmxDateFormat;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;

public class PacketSender
extends BufferedConsumer
implements HrdCommandHandler {
    private ReturnAddressTable rat;
    PacketWrapper pw;
    DatagramSocket ds;
    private int sendDelay;
    private boolean retxEnabled = true;
    private String lastReportTime;
    private int sendCount;
    private NmxDateFormat dateFormat = new NmxDateFormat("yyyy/MM/dd_HH:mm:ss");

    public PacketSender(DatagramSocket socket, ReturnAddressTable raTable) {
        super("PacketSender", 1000);
        this.rat = raTable;
        this.ds = socket;
        this.pw = new InternetPacketWrapper();
        this.sendDelay = 0;
        this.resetStatus();
    }

    public synchronized void setSocket(DatagramSocket socket) {
        this.ds = socket;
    }

    public synchronized void send(DatagramPacket dp) throws IOException {
        ++this.sendCount;
        this.ds.send(dp);
    }

    protected void open() {
        this.setPriority(8);
        Log.report(this, 5, 2, "starting with priority " + this.getPriority());
    }

    protected void close() {
        Log.report(this, 6, 1, "quitting...");
    }

    protected void process(Object obj) {
        if (!this.isRetxEnabled() && obj instanceof ReTxRequestPacket) {
            return;
        }
        HrdCommandPacket packet = (HrdCommandPacket)obj;
        Log.report(this, 7, 1, "" + packet);
        ReturnAddress radd = this.rat.lookup(packet.getInstrumentID());
        if (radd != null) {
            byte[] message = this.pw.makeWrappedPacket(packet);
            try {
                this.send(new DatagramPacket(message, message.length, radd.getInetAddress(), radd.getInetPort()));
                Thread.sleep(this.getSendDelay());
            }
            catch (IOException e) {
                Log.report(this, 8, 3, String.valueOf(e.getMessage()) + " for " + packet);
            }
            catch (InterruptedException interruptedException) {}
        } else {
            Log.report(this, 9, 3, "No address for " + packet);
        }
    }

    public void put(HrdCommandPacket packet) {
        this.append(packet);
    }

    public void setSendDelay(int millis) {
        if (millis < 0) {
            millis = 0;
        }
        this.sendDelay = millis;
    }

    public int getSendDelay() {
        return this.sendDelay;
    }

    public void setRetxEnabled(boolean enabled) {
        this.retxEnabled = enabled;
        Log.report(this, 6, 2, "ReTx request transmission " + (this.retxEnabled ? "enabled" : "disabled"));
    }

    public boolean isRetxEnabled() {
        return this.retxEnabled;
    }

    protected void reportStatus() {
        Log.report(this, 0, 2, "Packets sent since " + this.lastReportTime + ": " + this.sendCount);
        int queueSize = this.getQsize();
        if (queueSize > 0) {
            Log.report(this, 0, 2, "Packets queued: " + queueSize);
        }
    }

    public void reportStatus(String hint) {
        if (hint.equals("TX") || hint.equals("ALL") || hint.equals("SUMMARY")) {
            this.reportStatus();
        }
    }

    protected void resetStatus() {
        this.lastReportTime = this.dateFormat.format(System.currentTimeMillis() / 1000L);
        this.sendCount = 0;
    }

    public synchronized void reportSummary() {
        this.reportStatus();
        this.resetStatus();
    }
}

