/*
 * Decompiled with CFR 0.152.
 */
public class RangeImp
implements Range {
    private int start;
    private int end;

    public RangeImp(int rangeStart, int rangeEnd) {
        this.start = rangeStart;
        this.end = rangeEnd;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public void setStart(int rangeStart) {
        this.start = rangeStart;
    }

    public void setEnd(int rangeEnd) {
        this.end = rangeEnd;
    }

    public int size() {
        if (this.start <= this.end) {
            return this.end + 1 - this.start;
        }
        return 0;
    }

    public boolean contains(int sequence) {
        return sequence >= this.start && sequence <= this.end;
    }

    public boolean intersects(Range range) {
        return this.end >= range.getStart() && this.start <= range.getEnd();
    }

    public final RangeImp copy() {
        return this.createRange(this.start, this.end);
    }

    public RangeImp createRange(int rangeStart, int rangeEnd) {
        return new RangeImp(rangeStart, rangeEnd);
    }

    public String toString() {
        return String.valueOf(this.start) + " - " + this.end;
    }
}

