/*
 * Decompiled with CFR 0.152.
 */
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;

public class RangeList {
    private LinkedList list = new LinkedList();
    private int lostPackets = 0;
    private int lostRanges = 0;

    public int size() {
        return this.list.size();
    }

    public int totalCount() {
        int count = 0;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            RangeImp range = (RangeImp)iter.next();
            count += range.size();
        }
        return count;
    }

    public int getLostRangeCount() {
        return this.lostRanges;
    }

    public int getLostPacketCount() {
        return this.lostPackets;
    }

    public void incrementLostCount(int packetsLost) {
        this.lostPackets += packetsLost;
        ++this.lostRanges;
    }

    public void resetLostCount() {
        this.lostPackets = 0;
        this.lostRanges = 0;
    }

    public RangeImp removeFirst() {
        return (RangeImp)this.list.removeFirst();
    }

    public RangeImp removeLast() {
        return (RangeImp)this.list.removeLast();
    }

    public RangeImp firstRange() {
        return (RangeImp)this.list.getFirst();
    }

    public RangeImp lastRange() {
        return (RangeImp)this.list.getLast();
    }

    public int firstStart() {
        return this.firstRange().getStart();
    }

    public int lastEnd() {
        return this.lastRange().getEnd();
    }

    public void add(RangeImp range) {
        int position = range.getStart();
        boolean pending = true;
        ListIterator<RangeImp> iter = this.list.listIterator();
        while (pending && iter.hasNext()) {
            Range next = (Range)iter.next();
            if (next.getStart() <= position) continue;
            iter.previous();
            iter.add(range);
            pending = false;
        }
        if (pending) {
            iter.add(range);
        }
    }

    public boolean remove(RangeImp range) {
        return this.list.remove(range);
    }

    public void consolidate() {
        ListIterator iter = this.listIterator();
        if (iter.hasNext()) {
            RangeImp range = (RangeImp)iter.next();
            while (iter.hasNext()) {
                RangeImp next = (RangeImp)iter.next();
                if (range.getEnd() + 1 >= next.getStart()) {
                    range.setEnd(Math.max(range.getEnd(), next.getEnd()));
                    iter.remove();
                    continue;
                }
                range = next;
            }
        }
    }

    public int clearBefore(int firstSeq) {
        RangeImp range;
        int removeCount = 0;
        while (this.size() > 0 && this.firstRange().getEnd() < firstSeq) {
            range = this.firstRange();
            removeCount += range.size();
            this.lostPackets += range.size();
            ++this.lostRanges;
            this.remove(range);
        }
        if (this.size() > 0 && this.firstRange().getStart() < firstSeq) {
            range = this.firstRange();
            int rangeStart = range.getStart();
            removeCount += firstSeq - rangeStart;
            this.lostPackets += firstSeq - rangeStart;
            range.setStart(firstSeq);
        }
        return removeCount;
    }

    public void remove(int sequenceNum) {
        ListIterator iter = this.listIterator();
        while (iter.hasNext()) {
            int rangeEnd;
            RangeImp range = (RangeImp)iter.next();
            if (!range.contains(sequenceNum)) continue;
            int rangeStart = range.getStart();
            if (rangeStart == (rangeEnd = range.getEnd())) {
                iter.remove();
            } else if (rangeStart == sequenceNum) {
                range.setStart(sequenceNum + 1);
            } else if (rangeEnd == sequenceNum) {
                range.setEnd(sequenceNum - 1);
            } else {
                RangeImp nextb = range.copy();
                range.setEnd(sequenceNum - 1);
                nextb.setStart(sequenceNum + 1);
                iter.add(nextb);
            }
            return;
        }
    }

    public boolean intersects(Range rhs) {
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            RangeImp range = (RangeImp)iter.next();
            if (!range.intersects(rhs)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(int sequenceNum) {
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            RangeImp range = (RangeImp)iter.next();
            if (!range.contains(sequenceNum)) continue;
            return true;
        }
        return false;
    }

    public RangeImp getRange(int sequenceNum) {
        ListIterator iter = this.listIterator();
        while (iter.hasNext()) {
            RangeImp range = (RangeImp)iter.next();
            if (!range.contains(sequenceNum)) continue;
            return range;
        }
        return null;
    }

    public void clear() {
        this.lostRanges += this.size();
        this.lostPackets += this.totalCount();
        this.list.clear();
    }

    public ListIterator listIterator() {
        return this.list.listIterator();
    }

    public Iterator iterator() {
        return this.list.iterator();
    }

    public Iterator reverseIterator() {
        return new ReverseIterator(this.list);
    }

    public void show() {
        int rangeNum = 0;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            System.out.println("range " + ++rangeNum + ": " + iter.next());
        }
        System.out.println();
    }

    public void showBack() {
        int rangeNum = 0;
        Iterator iter = this.reverseIterator();
        while (iter.hasNext()) {
            System.out.println("range " + ++rangeNum + ": " + iter.next());
        }
        System.out.println();
    }
}

