/*
 * Decompiled with CFR 0.152.
 */
public class RequestList {
    private RangeList list = new RangeList();

    public int size() {
        return this.list.size();
    }

    public synchronized int packetCount() {
        return this.list.totalCount();
    }

    public boolean contains(int sequenceNum) {
        return this.list.contains(sequenceNum);
    }

    public void clear() {
        this.list.clear();
    }

    public int clearBefore(int firstSeq) {
        return this.list.clearBefore(firstSeq);
    }

    public void remove(int sequenceNum) {
        this.list.remove(sequenceNum);
    }

    public void addRange(int first, int last) {
        if (first <= last) {
            this.list.add(new RangeImp(first, last));
            this.list.consolidate();
        }
    }

    public Range removeFirst(int numPackets) {
        if (this.list.size() < 1) {
            return null;
        }
        RangeImp range = this.list.firstRange();
        if (numPackets < 1 || range.size() <= numPackets) {
            this.list.removeFirst();
            return range;
        }
        int start = range.getStart();
        range.setStart(start + numPackets);
        return new RangeImp(start, start + numPackets - 1);
    }

    public Range removeLast(int numPackets) {
        if (this.list.size() < 1) {
            return null;
        }
        RangeImp range = this.list.lastRange();
        if (numPackets < 1 || range.size() <= numPackets) {
            this.list.removeLast();
            return range;
        }
        int end = range.getEnd();
        range.setEnd(end - numPackets);
        return new RangeImp(end + 1 - numPackets, end);
    }

    public void show() {
        this.list.show();
    }
}

