/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.msg.ChannelList;
import ca.nanometrics.naqs.stndb.InstrumentConfig;
import ca.nanometrics.naqs.stndb.StationDatabase;
import ca.nanometrics.packet.ChannelKey;
import ca.nanometrics.packet.Instrument;
import ca.nanometrics.util.Log;
import ca.nanometrics.util.NmxDateFormat;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;

public class ReturnAddressTable {
    private static final int DEFAULT_TIMEOUT = 10000;
    private static final int REWRITE_INTERVAL = 3600000;
    private StationDatabase stndb;
    private String filename;
    private int saveTimeout;
    private Hashtable table = new Hashtable();
    private boolean changed = false;
    private long timeOfLastSave;

    public ReturnAddressTable(StationDatabase database, String ratFile, int timeout) {
        this.stndb = database;
        this.filename = ratFile;
        this.saveTimeout = timeout > 0 ? timeout : 10000;
        this.initTable();
        this.saveTable();
    }

    public ReturnAddressTable(StationDatabase database, String ratFile) {
        this(database, ratFile, 10000);
    }

    private Integer keyOf(int ID) {
        return new Integer(ID);
    }

    private ReturnAddress add(ReturnAddress radd) {
        this.changed = true;
        int ID = radd.getInstrumentID();
        return this.table.put(this.keyOf(ID), radd);
    }

    private ReturnAddress remove(int ID) {
        this.changed = true;
        return (ReturnAddress)this.table.remove(this.keyOf(ID));
    }

    private void setFixedAddress(int ID, String host, int port) throws UnknownHostException {
        InetAddress addr = InetAddress.getByName(host);
        this.add(new ReturnAddress(ID, addr, port, false));
    }

    private void initTable() {
        Vector instruments = this.stndb.getInstruments();
        Enumeration e = instruments.elements();
        while (e.hasMoreElements()) {
            InstrumentConfig inst = (InstrumentConfig)e.nextElement();
            if (inst.hasDynamicAddress()) continue;
            try {
                this.setFixedAddress(inst.getInstrumentID(), inst.getInetHostName(), inst.getInetPort());
            }
            catch (UnknownHostException exc) {
                Log.report(this, 2, 3, "Unknown host " + inst.getInetHostName() + " for instrument " + inst.getInstrumentID());
            }
        }
    }

    private boolean timeToSave() {
        long now = System.currentTimeMillis();
        int millisSinceSave = (int)(now - this.timeOfLastSave & Integer.MAX_VALUE);
        if (this.changed) {
            return millisSinceSave > this.saveTimeout;
        }
        return millisSinceSave > 3600000;
    }

    public void updateReturnAddress(int ID, InetAddress addr, int port) {
        ReturnAddress rad = this.lookup(ID);
        if (rad != null) {
            if (rad.isDynamic()) {
                this.changed |= rad.setAddress(addr, port);
            }
        } else {
            this.add(new ReturnAddress(ID, addr, port, true));
        }
        if (this.timeToSave()) {
            this.saveTable();
        }
    }

    public ReturnAddress lookup(int ID) {
        return (ReturnAddress)this.table.get(this.keyOf(ID));
    }

    private TreeSet getInstrumentSet() {
        TreeSet<String> instruments = new TreeSet<String>();
        Enumeration enumeration = this.table.elements();
        while (enumeration.hasMoreElements()) {
            instruments.add(this.getRaddString((ReturnAddress)enumeration.nextElement()));
        }
        return instruments;
    }

    private TreeSet getStationSet() {
        ChannelList clist = this.stndb.getChannelList();
        int[] keys = clist.getChannelKeys(2);
        TreeSet<String> stations = new TreeSet<String>();
        int ix = 0;
        while (ix < keys.length) {
            int key = keys[ix];
            int instID = ChannelKey.getIDOf(key);
            ReturnAddress radd = this.lookup(instID);
            if (radd != null) {
                String channelName = clist.getNameOf(key);
                int dotLoc = channelName.indexOf(46);
                if (dotLoc > 0) {
                    channelName = channelName.substring(0, dotLoc);
                }
                String entry = String.valueOf(channelName) + "/" + this.getRaddString(radd);
                stations.add(entry);
            }
            ++ix;
        }
        return stations;
    }

    private void writeEntrySet(PrintWriter pw, String header, TreeSet set) {
        pw.println();
        pw.println("[ " + header + " ]");
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            pw.println(iter.next());
        }
    }

    public void saveTable() {
        long saveTime;
        NmxDateFormat dfmt = new NmxDateFormat("yyyy/MM/dd HH:mm:ss");
        this.timeOfLastSave = saveTime = System.currentTimeMillis();
        this.changed = false;
        try {
            PrintWriter pw = new PrintWriter(new FileOutputStream(this.filename));
            pw.println("// NaqsServer return address table");
            pw.println("// Creation time:  " + dfmt.format(saveTime / 1000L));
            pw.println("// Automatically generated - do not edit");
            this.writeEntrySet(pw, "Instruments", this.getInstrumentSet());
            this.writeEntrySet(pw, "Stations", this.getStationSet());
            pw.close();
            Log.report(this, 1, 1, "Saved address table to " + this.filename);
        }
        catch (Exception any) {
            Log.report(this, 1, 3, "Error saving address table to " + this.filename);
        }
    }

    private String getRaddString(ReturnAddress radd) {
        StringBuffer sb = new StringBuffer(Instrument.getNameOf(radd.getInstrumentID()));
        sb.append(" = ");
        sb.append(radd.getHostAddress());
        sb.append(":");
        sb.append(radd.getInetPort());
        return sb.toString();
    }
}

