/*
 * Decompiled with CFR 0.152.
 */
import java.util.Iterator;

public class RetxList {
    private RangeList list = new RangeList();

    public int size() {
        return this.list.size();
    }

    public int rangeCount() {
        return this.list.size();
    }

    public synchronized int packetCount() {
        return this.list.totalCount();
    }

    public int getLostRangeCount() {
        return this.list.getLostRangeCount();
    }

    public int getLostPacketCount() {
        return this.list.getLostPacketCount();
    }

    public void incrementLostCount(int packetsLost) {
        this.list.incrementLostCount(packetsLost);
    }

    public void resetLostCount() {
        this.list.resetLostCount();
    }

    public void append(int rangeStart, int rangeEnd, int rangeTime) {
        if (rangeStart <= rangeEnd && (this.size() < 1 || rangeStart > this.list.lastRange().getEnd())) {
            this.list.add(new RetxRange(rangeStart, rangeEnd, rangeTime));
        }
    }

    public int clearBefore(int firstSeq) {
        return this.list.clearBefore(firstSeq);
    }

    public void remove(int sequenceNum, int timeOfSplit) {
        RetxRange range = (RetxRange)this.list.getRange(sequenceNum);
        if (range != null) {
            range.setUpdateTime(timeOfSplit);
            this.list.remove(sequenceNum);
        }
    }

    public boolean contains(int sequenceNum) {
        return this.list.contains(sequenceNum);
    }

    public void clear() {
        this.list.clear();
    }

    public Iterator iterator() {
        return this.list.iterator();
    }

    public Iterator reverseIterator() {
        return this.list.reverseIterator();
    }

    public void show() {
        this.list.show();
    }

    public void showBack() {
        this.list.showBack();
    }

    public void showStats() {
        System.out.println("C:" + this.packetCount() + " (" + this.rangeCount() + ")" + " U:" + this.getLostPacketCount() + " (" + this.getLostRangeCount() + ")");
    }

    public static void main(String[] args) throws Exception {
        RetxList bl = new RetxList();
        bl.append(3, 4, 5);
        bl.append(13, 14, 15);
        bl.append(23, 34, 8);
        bl.append(43, 46, 50);
        bl.append(62, 64, 85);
        bl.append(103, 204, 50);
        bl.show();
        bl.remove(30, 12);
        bl.show();
        bl.remove(62, 13);
        bl.show();
        bl.remove(64, 14);
        bl.show();
        bl.remove(64, 15);
        bl.show();
        bl.remove(63, 16);
        bl.show();
        bl.showBack();
        bl.remove(106, 17);
        bl.show();
        bl.remove(103, 17);
        bl.show();
        bl.remove(105, 17);
        bl.show();
        bl.remove(104, 17);
        bl.show();
        bl.showStats();
        bl.clearBefore(16);
        bl.show();
        bl.showStats();
        bl.clearBefore(32);
        bl.show();
        bl.showStats();
    }
}

