/*
 * Decompiled with CFR 0.152.
 */
public class RetxRange
extends RangeImp {
    private static final int[] factor = new int[]{1, 2, 4, 16, 60};
    private static final int maxfac = factor.length - 1;
    private int updateTime;
    private int requestCount;

    public RetxRange(int rangeStart, int rangeEnd, int rangeTime, int count) {
        super(rangeStart, rangeEnd);
        this.updateTime = rangeTime;
        this.requestCount = count;
    }

    public RetxRange(int rangeStart, int rangeEnd, int rangeTime) {
        this(rangeStart, rangeEnd, rangeTime, 0);
    }

    public int getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(int currentTime) {
        this.updateTime = currentTime;
    }

    public void request(int currentTime) {
        this.updateTime = currentTime;
        ++this.requestCount;
    }

    public int getTimeoutFactor() {
        int count = Math.min(this.requestCount, maxfac);
        return factor[count];
    }

    public int getTimeout(int nominalTimeout) {
        return nominalTimeout * this.getTimeoutFactor();
    }

    public RangeImp createRange(int rangeStart, int rangeEnd) {
        return new RetxRange(rangeStart, rangeEnd, this.updateTime, this.requestCount);
    }

    public String toString() {
        return String.valueOf(super.toString()) + ", " + this.requestCount + "(" + this.updateTime + ")";
    }
}

