/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.acq.RbfWrapper;
import ca.nanometrics.acq.YFile;
import ca.nanometrics.alert.Alert;
import ca.nanometrics.naqs.stndb.ChannelConfig;
import ca.nanometrics.packet.ChannelKey;
import ca.nanometrics.packet.DoDRequestPacket;
import ca.nanometrics.packet.HrdCommandHandler;
import ca.nanometrics.packet.HrdCommandPacket;
import ca.nanometrics.packet.Instrument;
import ca.nanometrics.packet.NmxPacket;
import ca.nanometrics.packet.NmxPacketFactory;
import ca.nanometrics.packet.NmxPacketHandler;
import ca.nanometrics.packet.ReTxRequestPacket;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.util.Log;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;

public class RingBuffer
implements NmxPacketHandler,
HrdCommandHandler,
NmxPacketSource {
    static final boolean DEBUG_ON = true;
    static final int DEAD_CHANNEL_REPORT_TIME = 600;
    static final int MAX_RETX_INTERVAL = 600;
    static final int FLUSH_TIMEOUT = 30;
    static final int RX_DISCARD_LIMIT = 20;
    static final int MAX_INDEX = 50;
    private ChannelConfig cfg;
    private int channelKey;
    private String keyName;
    protected String dottedName;
    private NmxPacketHandler distributor;
    private HrdCommandHandler retxHandler;
    private RbfWrapper rbf = new RbfWrapper();
    private RetxList missedPackets = new RetxList();
    private RbfIndexTable rbfIndexTable = new RbfIndexTable();
    private int maxBacklog;
    private int oldestAvailable;
    private int rxSinceAppend;
    private int lastSequenceNum;
    private double lastAppendTime;
    private int timeOfLastInsert;
    private int ticksUntilNextFlush;
    private int bytesSinceLastFlush;
    private boolean warnOnInvalidOld = true;
    private int packetsReceived = 0;
    private int packetsMissed = 0;
    private int packetsRecovered = 0;
    private int ticksSinceLastRx = 0;
    private int monitoringInterval = 0;
    private int timeOfLastReport = 0;
    private long timeOfLastReset = 0L;
    private int rbfWriteFails = 0;
    private ArrayList dodRequests = new ArrayList();
    private static final int MAX_DODREQUEST_TIME = 60;
    private int timeOfLastDoDUpgrade = 0;

    public RingBuffer(ChannelConfig config, NmxPacketHandler pktHandler, HrdCommandHandler cmdHandler) throws IOException {
        this.cfg = config;
        this.distributor = pktHandler;
        this.retxHandler = cmdHandler;
        this.dottedName = this.cfg.getDottedName();
        this.channelKey = this.cfg.getKey();
        this.keyName = ChannelKey.getKeyStringOf(this.channelKey);
        this.rxSinceAppend = 0;
        this.lastAppendTime = 0.0;
        this.lastSequenceNum = -1;
        this.oldestAvailable = 0;
        this.maxBacklog = 0;
        this.timeOfLastInsert = 0;
        this.ticksUntilNextFlush = (int)(30.0 * Math.random());
        this.bytesSinceLastFlush = 0;
        this.resetStatus();
        this.open();
    }

    public void close() {
        this.rbf.closeRingBuffer();
    }

    public void finalize() {
        this.close();
    }

    private YFile createYFile() {
        YFile yfl = new YFile();
        yfl.setStationName(this.cfg.getStationName());
        yfl.setOrientation(this.cfg.getChannelName());
        yfl.setComments(this.cfg.getDescription());
        yfl.setNetworkID(this.cfg.getNetworkID());
        yfl.setFormat(this.cfg.getFormat());
        yfl.setSensorType(this.cfg.getSensorType());
        yfl.setSensitivityUnits(this.cfg.getSensitivityUnits());
        yfl.setCalUnits(this.cfg.getCalibrationUnits());
        yfl.setSensitivity(this.cfg.getSensitivity());
        yfl.setSensitivityFreq(this.cfg.getSensitivityFreq());
        yfl.setResponseFile(this.cfg.getResponseFile());
        yfl.setLatitude(this.cfg.getLatitude());
        yfl.setLongitude(this.cfg.getLongitude());
        yfl.setElevation(this.cfg.getElevation());
        yfl.setDepth(this.cfg.getDepth());
        yfl.setAzimuth(this.cfg.getAzimuth());
        yfl.setDip(this.cfg.getDip());
        return yfl;
    }

    private void open() throws IOException {
        Log.report(this, 8, 1, "opening " + this.getDottedName());
        YFile yfl = this.createYFile();
        File path = new File(this.cfg.getRingBufferPath());
        path.mkdirs();
        int rc = this.rbf.createRingBuffer(this.cfg.getChannelPathName(), 1000000 * this.cfg.getRingBufferSize(), this.cfg.getInstrumentID(), this.cfg.getPacketLength(), yfl.getHandle(), this.cfg.getFileTag());
        if (rc != 0) {
            throw new IOException(String.valueOf(this.getDottedName()) + " createRingBuffer failed, rc = " + rc);
        }
        this.rbf.setWrap(this.cfg.canWrap());
        this.rbf.setAppendBuffer(this.cfg.getAppendSize(), 1);
        this.rbf.setInsertBuffer(this.cfg.getInsertSize());
        this.lastSequenceNum = this.rbf.newestSequence();
        this.maxBacklog = this.cfg.getMaxBacklog();
        if (this.maxBacklog > this.rbf.getMaxEntry() / 2) {
            this.maxBacklog = this.rbf.getMaxEntry() / 2;
        }
        this.rbfIndexTable.setCapacity(this.rbf.getMaxEntry());
        this.buildRetxList();
        this.buildIndexTable();
    }

    private int getSequence(int index) {
        int pktSequence = 0;
        byte[] pchPacket = this.rbf.getPacket(index % this.rbf.getMaxEntry());
        if (pchPacket != null) {
            try {
                NmxPacket packet = new NmxPacket(pchPacket, 0);
                pktSequence = packet.getSequenceNumber();
            }
            catch (InvalidInputException e) {
                e.printStackTrace();
            }
        }
        return pktSequence;
    }

    private Range findContiguousRange(int rangeStart, int rangeEnd) {
        int searchMin = rangeStart;
        int searchMax = rangeEnd;
        int seqAtEnd = this.getSequence(searchMax);
        int seqOffset = searchMax - seqAtEnd;
        while (searchMin < searchMax) {
            int searchMid = (searchMin + searchMax) / 2;
            int searchSeq = this.getSequence(searchMid);
            if (searchMid - searchSeq == seqOffset) {
                searchMax = searchMid;
                continue;
            }
            searchMin = searchMid + 1;
        }
        return new RangeImp(searchMin, rangeEnd);
    }

    private void buildRetxList() {
        if (this.rbf.getPacketCount() == 0) {
            return;
        }
        int searchStart = this.rbf.getOldestEntry();
        int searchEnd = this.rbf.getNewestEntry();
        if (searchEnd < searchStart) {
            searchEnd += this.rbf.getMaxEntry();
        }
        if (searchEnd - searchStart > this.maxBacklog) {
            searchStart = searchEnd - this.maxBacklog + 1;
        }
        Range range = this.findContiguousRange(searchStart, searchEnd);
        int scanStart = range.getStart();
        int scanEnd = range.getEnd();
        int maxNumPackets = this.rbf.getMaxEntry();
        int seqOffset = this.getSequence(searchEnd) - searchEnd;
        this.rbf.setIndexBuffer(8192);
        boolean fStartedBlock = false;
        int blockStart = 0;
        int blockEnd = 0;
        int index = 0;
        long indexTime = 0L;
        index = scanStart;
        while (index <= scanEnd) {
            indexTime = this.rbf.getIndexTime(index % maxNumPackets);
            if (fStartedBlock) {
                if (indexTime != 0L) {
                    fStartedBlock = false;
                    this.missedPackets.append(blockStart + seqOffset, blockEnd + seqOffset, 0);
                } else {
                    blockEnd = index;
                }
            } else if (indexTime == 0L) {
                fStartedBlock = true;
                blockStart = index;
                blockEnd = index;
            }
            ++index;
        }
        if (fStartedBlock) {
            this.missedPackets.append(blockStart + seqOffset, blockEnd + seqOffset, 0);
        }
        this.rbf.setIndexBuffer(0);
    }

    private void buildIndexTable() {
        this.rbfIndexTable.clear();
        if (this.rbf.getPacketCount() == 0) {
            return;
        }
        int maxEntry = this.rbf.getMaxEntry();
        int rangeStart = this.rbf.getOldestEntry();
        int rangeEnd = this.rbf.getNewestEntry();
        if (rangeEnd < rangeStart) {
            rangeEnd += maxEntry;
        }
        int nextSeq = this.getSequence(rangeEnd) + 1;
        while (rangeStart <= rangeEnd && this.rbfIndexTable.size() < 50) {
            Range indexRange = this.findContiguousRange(rangeStart, rangeEnd);
            int startIndex = indexRange.getStart();
            int startSeq = this.getSequence(startIndex);
            int endSeq = startSeq + indexRange.size() - 1;
            if (endSeq >= nextSeq) {
                rangeStart = rangeEnd + 1;
                continue;
            }
            this.rbfIndexTable.addRange(startSeq, endSeq, startIndex % maxEntry);
            rangeEnd = startIndex - 1;
            nextSeq = endSeq;
        }
    }

    protected void requestReTx(int currentTime, int first, int last) {
        int type = this.cfg.getType();
        if (type == 2 || type == 1) {
            this.retxHandler.put(new ReTxRequestPacket(currentTime, this.cfg.getInstrumentID(), this.cfg.getChannel() - 1, first, last));
        } else {
            this.retxHandler.put(new ReTxRequestPacket(currentTime, this.cfg.getInstrumentID(), type, this.cfg.getChannel(), first, last));
        }
    }

    protected NmxPacket makeNmxPacket(byte[] buffer) {
        if (buffer == null) {
            return null;
        }
        NmxPacket nmxPkt = null;
        try {
            nmxPkt = new NmxPacket(buffer, 0);
        }
        catch (InvalidInputException e) {
            Log.report(this, 20, 1, "Failed to create packet from rbf buffer. Error: " + e.getMessage());
        }
        return nmxPkt;
    }

    private void clearUnavailableBlocks(NmxPacket packet) {
        int removeCount = this.missedPackets.clearBefore(this.oldestAvailable);
        if (removeCount > 0) {
            Log.report(this, 13, 0, String.valueOf(this.keyName) + " abandoning " + removeCount + " packets before " + this.oldestAvailable + " pkt = " + packet.getSequenceNumber() + ", " + packet.getOldestSequence());
        }
    }

    private void forwardPacket(NmxPacket packet) {
        packet.setOldestSequence(this.rbfIndexTable.getFirstSequence());
        this.distributor.put(packet);
    }

    private void appendPacket(int nextSeq, NmxPacket packet) {
        this.clearUnavailableBlocks(packet);
        this.lastAppendTime = packet.getPacketTime() + 0.001;
        int pktSequence = packet.getSequenceNumber();
        if (nextSeq < pktSequence) {
            int currentTime = this.getCurrentTime();
            if (!packet.isDoD()) {
                this.requestReTx(currentTime, nextSeq, pktSequence - 1);
            }
            this.missedPackets.append(nextSeq, pktSequence - 1, currentTime);
            this.packetsMissed += pktSequence - nextSeq;
            NmxPacket nullPacket = NmxPacket.makeNullPacket(packet);
            int pktSeq = nextSeq;
            while (pktSeq < pktSequence) {
                nullPacket.setSequenceNumber(pktSeq);
                this.rbf.addPacket(nullPacket.getStorableBytes());
                this.rbfIndexTable.append(pktSeq, this.rbf.getNewestEntry());
                ++pktSeq;
            }
        }
        int rc = this.rbf.addPacket(packet.getStorableBytes());
        this.rbfIndexTable.append(pktSequence, this.rbf.getNewestEntry());
        if (rc != 0) {
            this.logRbfWriteError(rc);
        } else if (this.rbfWriteFails != 0) {
            this.logRbfWriteOk();
        }
        this.lastSequenceNum = pktSequence;
        this.rxSinceAppend = 0;
        this.bytesSinceLastFlush += packet.getStorableLength();
        this.forwardPacket(packet);
    }

    private void insertPacket(NmxPacket packet) {
        this.clearUnavailableBlocks(packet);
        int pktSequence = packet.getSequenceNumber();
        if (this.missedPackets.contains(pktSequence)) {
            int maxIndex = this.rbf.getMaxEntry();
            int index = (maxIndex + this.rbf.getNewestEntry() + pktSequence - this.lastSequenceNum) % maxIndex;
            this.rbf.insertPacket(packet.getStorableBytes(), index);
            int currentTime = this.getCurrentTime();
            this.missedPackets.remove(pktSequence, currentTime);
            this.timeOfLastInsert = currentTime;
            ++this.packetsRecovered;
            this.forwardPacket(packet);
        }
    }

    private String getInstrumentName() {
        return Instrument.getNameOf(this.cfg.getInstrumentID());
    }

    private void logRbfWriteError(int rc) {
        ++this.rbfWriteFails;
        if (this.rbfWriteFails == 1 || this.rbfWriteFails == 100 || this.rbfWriteFails == 1000 || this.rbfWriteFails % 10000 == 0) {
            Log.report(this, 9, 3, String.valueOf(this.getDottedName()) + " write failed, rc = " + rc + ", count = " + this.rbfWriteFails);
            Alert.report("RbfWriteFail", this.rbfWriteFails, "Ringbuffer write failure on %1, rc = %2, count = %p.", "/" + this.getDottedName() + "/" + rc);
        }
    }

    private void logRbfWriteOk() {
        Log.report(this, 9, 3, String.valueOf(this.getDottedName()) + " write succeeded after " + this.rbfWriteFails + " failures");
        Alert.report("RbfWriteOk", this.rbfWriteFails, "Ringuffer write succeeded on %1 after %p failures.", "/" + this.getDottedName());
        this.rbfWriteFails = 0;
    }

    public synchronized void put(NmxPacket packet) {
        if (packet.isDoD()) {
            Log.report(this, 50, 0, "DoD packet: " + packet.toString());
        }
        boolean isGap = packet.getSequenceNumber() != this.lastSequenceNum + 1;
        Log.report(this, 5, 0, "Rx " + this.keyName + " " + packet.getSequenceNumber() + (packet.isReTx() ? "R" : "") + ", old " + packet.getOldestSequence() + (isGap ? ", exp " + (this.lastSequenceNum + 1) : ""));
        if (packet.getKey() != this.channelKey) {
            return;
        }
        if (this.ticksSinceLastRx >= 600) {
            Log.report(this, 1, 2, String.valueOf(this.getDottedName()) + " is now receiving from " + this.getInstrumentName());
        }
        this.ticksSinceLastRx = 0;
        ++this.packetsReceived;
        if (!this.rbf.isOpen()) {
            Log.report(this, 1, 3, String.valueOf(this.keyName) + " Ringbuffer not open");
            return;
        }
        if (packet.getStorableLength() != this.cfg.getPacketLength()) {
            Log.report(this, 2, 3, String.valueOf(this.keyName) + " Wrong packet length: " + packet.getStorableLength() + " exp " + this.cfg.getPacketLength());
            return;
        }
        if (packet.getLongSeconds() == 0L) {
            return;
        }
        int expectedSequence = this.lastSequenceNum + 1;
        int pktSequence = packet.getSequenceNumber();
        int pktOldestSeq = packet.getOldestSequence();
        if (pktOldestSeq > pktSequence) {
            pktOldestSeq = pktSequence;
        }
        if (pktOldestSeq + this.maxBacklog < pktSequence) {
            int invalidOld = pktOldestSeq;
            pktOldestSeq = pktSequence - this.maxBacklog;
            if (this.warnOnInvalidOld) {
                this.warnOnInvalidOld = false;
                Log.report(this, 3, 3, String.valueOf(this.keyName) + " memory may exceed configured size");
            }
            if (expectedSequence + this.maxBacklog < pktSequence) {
                Log.report(this, 4, 3, String.valueOf(this.keyName) + " seq:" + pktSequence + " reset old seq: " + invalidOld + " to " + pktOldestSeq);
            }
        }
        if (pktSequence >= expectedSequence) {
            if (this.oldestAvailable < pktOldestSeq) {
                this.oldestAvailable = pktOldestSeq;
            }
            if (this.oldestAvailable > expectedSequence) {
                this.packetsMissed += this.oldestAvailable - expectedSequence;
                this.missedPackets.incrementLostCount(this.oldestAvailable - expectedSequence);
                this.appendPacket(this.oldestAvailable, packet);
            } else {
                this.appendPacket(expectedSequence, packet);
            }
        } else if (packet.isReTx() && pktSequence >= this.oldestAvailable) {
            if (this.oldestAvailable < pktOldestSeq) {
                this.oldestAvailable = pktOldestSeq;
            }
            this.insertPacket(packet);
        } else if (!packet.isReTx() && (packet.getPacketTime() > this.lastAppendTime || ++this.rxSinceAppend > 20)) {
            this.oldestAvailable = pktOldestSeq;
            this.missedPackets.clear();
            this.appendPacket(this.oldestAvailable, packet);
        }
        if (packet.isDoD()) {
            this.updateDoDManager(packet);
        } else {
            this.requestMissingPackets();
        }
    }

    private void requestMissingPackets(int currentTime, Iterator iter) {
        int nominalTimeout = this.cfg.getRequestInterval();
        int blockCount = 0;
        int totalPackets = 0;
        while (iter.hasNext()) {
            int reTxTimeout;
            RetxRange block = (RetxRange)iter.next();
            ++blockCount;
            totalPackets += block.size();
            int secSinceRequested = currentTime - block.getUpdateTime();
            if (secSinceRequested > (reTxTimeout = block.getTimeout(nominalTimeout)) || secSinceRequested > 600) {
                block.request(currentTime);
                this.requestReTx(currentTime, block.getStart(), block.getEnd());
            }
            if (blockCount > 2 && totalPackets >= 20) break;
        }
    }

    private void requestMissingPackets() {
        int currentTime = this.getCurrentTime();
        this.requestMissingPackets(currentTime, this.missedPackets.iterator());
        this.requestMissingPackets(currentTime, this.missedPackets.reverseIterator());
    }

    private void updateDoDManager(NmxPacket packet) {
        Iterator iter = this.dodRequests.iterator();
        while (iter.hasNext()) {
            DoDRequestManager dodMgr = (DoDRequestManager)iter.next();
            if (!dodMgr.packetAcceptable(packet)) continue;
            dodMgr.put(packet);
        }
        Log.report(this, 51, 0, "Packet: " + packet + " has no DoDManager.");
    }

    public synchronized void tick(int currentTime) {
        int reportInterval;
        if (this.timeOfLastInsert != 0 && this.timeOfLastInsert + 30 < currentTime) {
            this.rbf.flushInsertBuffer();
            this.timeOfLastInsert = 0;
        }
        if (++this.ticksSinceLastRx == 600) {
            Log.report(this, 1, 3, String.valueOf(this.getDottedName()) + ": no data received for " + 600 + " seconds");
        }
        if (--this.ticksUntilNextFlush <= 0) {
            if (this.bytesSinceLastFlush < this.cfg.getAppendSize()) {
                this.rbf.flushAppendBuffer();
            }
            this.bytesSinceLastFlush = 0;
            this.ticksUntilNextFlush = 30;
        }
        if (this.monitoringInterval > 0 && (reportInterval = currentTime / this.monitoringInterval) != this.timeOfLastReport) {
            this.reportStatus();
            this.timeOfLastReport = reportInterval;
        }
        try {
            this.updateDoDRequests();
        }
        catch (ConcurrentModificationException e) {
            e.printStackTrace();
        }
    }

    protected int getCurrentTime() {
        return (int)((double)System.currentTimeMillis() / 1000.0);
    }

    private void updateDoDRequests() throws ConcurrentModificationException {
        if (this.dodRequests.size() == 0) {
            return;
        }
        if (this.getCurrentTime() - this.timeOfLastDoDUpgrade < 60) {
            return;
        }
        this.timeOfLastDoDUpgrade = this.getCurrentTime();
        Log.report(this, 52, 1, "Updating " + this.dodRequests.size() + " Data on Demand Requests.");
        ArrayList<DoDRequestManager> done = new ArrayList<DoDRequestManager>();
        int i = 0;
        while (i < this.dodRequests.size()) {
            DoDRequestManager mgr = (DoDRequestManager)this.dodRequests.get(i);
            if (mgr.complete()) {
                done.add(mgr);
                Log.report(this, 53, 2, mgr.toString());
            } else {
                mgr.retx();
                if (mgr.lastRetx()) {
                    done.add(mgr);
                    Log.report(this, 54, 2, "DoDRequest has expired. " + mgr.toString());
                } else {
                    Log.report(this, 59, 2, "DoDRequest Status. " + mgr.toString());
                }
            }
            ++i;
        }
        Iterator iter = done.iterator();
        block3: while (iter.hasNext()) {
            Object obj = iter.next();
            while (true) {
                try {
                    this.dodRequests.remove(obj);
                    continue block3;
                }
                catch (ConcurrentModificationException cme) {
                    Log.report(this, 55, 0, "Waiting to remove DoDRequest.");
                    continue;
                }
                break;
            }
        }
    }

    public synchronized int requestPackets(int key, int first, int last, NmxPacketHandler dest) {
        int count = 0;
        if (key == this.channelKey) {
            Log.report(this, 8, 0, String.valueOf(this.keyName) + " received retx " + first + "-" + last);
            int maxEntry = this.rbf.getMaxEntry();
            IndexMap map = null;
            int reqSeq = last;
            while (reqSeq >= first) {
                if (!this.missedPackets.contains(reqSeq)) {
                    if (map == null || !map.contains(reqSeq)) {
                        map = this.rbfIndexTable.getIndexMap(reqSeq);
                    }
                    if (map != null) {
                        int pktIndex = map.getIndexOf(reqSeq) % maxEntry;
                        try {
                            NmxPacket packet = NmxPacketFactory.makePacket(this.rbf.getPacket(pktIndex));
                            int pktSeq = packet.getSequenceNumber();
                            if (pktSeq == reqSeq && packet.getLongSeconds() > 0L) {
                                packet.setReTx(true);
                                packet.setOldestSequence(this.rbfIndexTable.getFirstSequence());
                                dest.put(packet);
                                ++count;
                            }
                        }
                        catch (Exception any) {
                            Log.report(this, 3, 3, String.valueOf(this.keyName) + " error reading ringbuffer");
                        }
                    }
                }
                --reqSeq;
            }
        }
        return count;
    }

    public synchronized void resetStatus() {
        this.packetsReceived = 0;
        this.packetsMissed = 0;
        this.packetsRecovered = 0;
        this.missedPackets.resetLostCount();
        this.timeOfLastReset = System.currentTimeMillis();
    }

    public String getDottedName() {
        return this.dottedName;
    }

    public synchronized void setMonitoringInterval(int seconds) {
        if (seconds > 0) {
            this.monitoringInterval = seconds;
            int currentTime = this.getCurrentTime();
            this.timeOfLastReport = currentTime / this.monitoringInterval;
        } else {
            this.monitoringInterval = 0;
        }
    }

    public synchronized void reportStatus() {
        long secSinceReset = (System.currentTimeMillis() - this.timeOfLastReset) / 1000L;
        Log.report(this.getDottedName(), 0, 2, "P:" + this.packetsReceived + " M:" + this.packetsMissed + " R:" + this.packetsRecovered + " C:" + this.missedPackets.packetCount() + " (" + this.missedPackets.rangeCount() + ")" + " U:" + this.missedPackets.getLostPacketCount() + " (" + this.missedPackets.getLostRangeCount() + ")" + " T:" + secSinceReset + " L:" + this.ticksSinceLastRx);
    }

    public void put(HrdCommandPacket packet) {
        if (packet.getKey() != this.cfg.getKey()) {
            return;
        }
        if (!(packet instanceof DoDRequestPacket)) {
            Log.report(this, 8, 4, "Don't know what to do with: " + packet.toString());
            return;
        }
        Log.report(this, 60, 2, "Received: " + packet.toString() + " for: " + this.cfg.getStationName() + "." + this.cfg.getChannelName());
        DoDRequestPacket p = (DoDRequestPacket)packet;
        DoDRequestManager dodMgr = new DoDRequestManager(p);
        if (!this.dodRequests.contains(dodMgr)) {
            this.timeOfLastDoDUpgrade = this.getCurrentTime();
            this.dodRequests.add(dodMgr);
        }
    }

    public class DoDRequestManager {
        private DoDRequestPacket pkt;
        private ArrayList missingSeq = new ArrayList();
        private int begin;
        private boolean lastRetx = false;
        private NmxPacket lastPkt;
        private NmxPacket earliestPkt;
        private NmxPacket latestPkt;
        private int lastRetxTime = 0;

        public DoDRequestManager(DoDRequestPacket _pkt) {
            this.pkt = _pkt;
            this.begin = (int)((double)System.currentTimeMillis() / 1000.0);
        }

        public DoDRequestPacket getRequestPacket() {
            return this.pkt;
        }

        public boolean complete() {
            return this.missingSeq.size() == 0 && !this.startMissing() && !this.endMissing();
        }

        private boolean startMissing() {
            if (this.earliestPkt == null) {
                return false;
            }
            long time = this.earliestPkt.getLongSeconds();
            return Math.abs((long)this.pkt.getStartTime() - time) > 5L;
        }

        private boolean endMissing() {
            if (this.latestPkt == null) {
                return false;
            }
            long time = this.latestPkt.getLongSeconds();
            return Math.abs((long)this.pkt.getEndTime() - time) > 5L;
        }

        public boolean packetAcceptable(NmxPacket nmxPkt) {
            long pktTime = nmxPkt.getLongSeconds();
            int start = this.pkt.getStartTime();
            int end = this.pkt.getEndTime();
            if ((long)start - pktTime > 5L) {
                return false;
            }
            return pktTime - (long)end <= 5L;
        }

        private int getLastSeq() {
            if (this.lastPkt == null) {
                return -2147483647;
            }
            return this.lastPkt.getSequenceNumber();
        }

        private int getEarliestSeq() {
            if (this.earliestPkt == null) {
                return Integer.MAX_VALUE;
            }
            return this.earliestPkt.getSequenceNumber();
        }

        private int getLatestSeq() {
            if (this.latestPkt == null) {
                return -2147483647;
            }
            return this.latestPkt.getSequenceNumber();
        }

        public void put(NmxPacket nmxPkt) {
            Log.report(this, 56, 1, "Received from: " + RingBuffer.this.dottedName + " " + nmxPkt.getLongSeconds() + " seq: " + nmxPkt.getSequenceNumber());
            int currSeq = nmxPkt.getSequenceNumber();
            int lastSeq = this.getLastSeq();
            if (this.missingSeq.contains(new Integer(currSeq))) {
                this.missingSeq.remove(new Integer(currSeq));
            } else if (lastSeq != -2147483647) {
                if (currSeq < lastSeq - 1) {
                    int i = currSeq + 1;
                    while (i < lastSeq) {
                        if (!this.missingSeq.contains(new Integer(i))) {
                            this.missingSeq.add(new Integer(i));
                        }
                        ++i;
                    }
                } else if (currSeq > lastSeq + 1) {
                    int i = lastSeq + 1;
                    while (i < currSeq) {
                        if (!this.missingSeq.contains(new Integer(i))) {
                            this.missingSeq.add(new Integer(i));
                        }
                        ++i;
                    }
                }
            }
            this.lastPkt = nmxPkt;
            if (this.getEarliestSeq() > currSeq) {
                this.earliestPkt = nmxPkt;
            }
            if (this.getLatestSeq() < currSeq) {
                this.latestPkt = nmxPkt;
            }
        }

        public String toString() {
            String retStr = this.pkt.toString();
            if (this.missingSeq.size() > 0) {
                retStr = String.valueOf(retStr) + " " + this.missingSeq.size() + " gaps; ";
            }
            if (this.startMissing()) {
                retStr = String.valueOf(retStr) + " Data missing at beginning.";
            }
            if (this.endMissing()) {
                retStr = String.valueOf(retStr) + " Data missing at end.";
            }
            if (this.lastPkt == null) {
                retStr = String.valueOf(retStr) + " No data received.";
            }
            if (retStr.equalsIgnoreCase(this.pkt.toString())) {
                retStr = String.valueOf(retStr) + " Data Retrieval Complete.";
            }
            return retStr;
        }

        protected boolean lastRetx() {
            return this.lastRetx;
        }

        public void retx() {
            int startSeq;
            if (Math.abs(this.begin - RingBuffer.this.getCurrentTime()) > this.pkt.getMaxTime()) {
                this.lastRetx = true;
            }
            if (this.missingSeq.size() == 0) {
                return;
            }
            if (RingBuffer.this.getCurrentTime() - this.lastRetxTime < 600) {
                return;
            }
            this.lastRetxTime = RingBuffer.this.getCurrentTime();
            Collections.sort(this.missingSeq);
            int endSeq = startSeq = ((Integer)this.missingSeq.get(0)).intValue();
            int i = 1;
            while (i < this.missingSeq.size()) {
                int seq = (Integer)this.missingSeq.get(i);
                if (seq == endSeq + 1) {
                    endSeq = seq;
                } else {
                    if (this.lastPkt != null && this.lastPkt.getOldestSequence() > endSeq) {
                        this.lastRetx = true;
                    }
                    Log.report(this, 58, 2, this.pkt + " ReTx: " + startSeq + " to " + endSeq);
                    RingBuffer.this.requestReTx(RingBuffer.this.getCurrentTime(), startSeq, endSeq);
                    startSeq = endSeq = seq;
                }
                ++i;
            }
        }
    }
}

