/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.packet.StaLtaTrigger;
import ca.nanometrics.packet.TriggerHandler;
import ca.nanometrics.util.Format;
import ca.nanometrics.util.Log;

public class StaLtaDetectorImp
implements DetectorImp {
    static final int kusMaxTriggerOrder = 5;
    static final int kusMaxTriggerStages = 3;
    static final int kusNotTriggered = 0;
    static final int kusTriggerStart = 0;
    static final int kusTriggerEarly = 1;
    static final int kusTriggerFinal = 2;
    static final double MIN_STA_CONST = 1.0E-4;
    static final double MIN_LTA_CONST = 0.001;
    static final double MIN_TRIG_LEVEL = 1.5;
    static final double MIN_REPT_TIME = 0.2;
    static final double MIN_AMP_RATIO = 1.0E-8;
    static final double[] damping = new double[]{1.0, 1.0, 0.707, 0.5, 0.382683, 0.30915};
    static int timeout = 3600;
    private TriggerHandler handler;
    private String stnid;
    private int triggerID;
    private boolean isInitialized;
    private int sampleRate;
    private int hpOrder;
    private double hpFreqHz;
    private int lpOrder;
    private double lpFreqHz;
    private double staConst;
    private double ltaConst;
    private double trigLevel;
    private double earlyReportTime;
    private IirFilter[] stage = new IirFilter[3];
    private LP1Filter staFilter;
    private LP1Filter ltaFilter;
    private LP1Filter inputLta;
    private int samplesToSettleHP = 0;
    private int samplesToSettleLTA = 0;
    private double nextPacketTime = 0.0;
    private double packetTime;
    private int sampleNum;
    private int sampleToTimeout;
    private int earlyReportSample;
    private double ratio;
    private int trigState;
    private double triggerTime;
    private double peakSta;
    private double ltaAtStart;
    private int maxPeakToPeak;
    private double startOfMaxPeak;
    private double endOfMaxPeak;
    private int lastSample;
    private int lastReversal;
    private double timeOfLastReversal;
    private int direction;

    public StaLtaDetectorImp(String stnid, int triggerID, int hpOrder, double hpFreqHz, int lpOrder, double lpFreqHz, double staConst, double ltaConst, double trigLevel, double earlyReportTime, TriggerHandler handler) {
        this.stnid = stnid;
        this.triggerID = triggerID;
        this.hpOrder = Math.max(Math.min(hpOrder, 5), 0);
        this.hpFreqHz = Math.abs(hpFreqHz);
        this.lpOrder = Math.max(Math.min(lpOrder, 5 - hpOrder), 0);
        this.lpFreqHz = Math.abs(lpFreqHz);
        this.staConst = Math.max(Math.abs(staConst), 1.0E-4);
        this.ltaConst = Math.max(Math.abs(ltaConst), 0.001);
        this.trigLevel = Math.max(Math.abs(trigLevel), 1.5);
        this.earlyReportTime = Math.max(Math.abs(earlyReportTime), 0.2);
        this.handler = handler;
        this.sampleRate = 1;
        this.isInitialized = false;
        this.stage[0] = new IirFilter();
        this.stage[1] = new IirFilter();
        this.stage[2] = new IirFilter();
        this.staFilter = new LP1Filter();
        this.ltaFilter = new LP1Filter();
        this.inputLta = new LP1Filter();
    }

    public void setSampleRate(int newSampleRate) {
        if (newSampleRate <= 0) {
            newSampleRate = 1;
        }
        if (this.sampleRate != newSampleRate) {
            this.sampleRate = newSampleRate;
            this.isInitialized = false;
        }
    }

    public void initialize() {
        int usStage = 0;
        switch (this.hpOrder) {
            case 1: {
                this.stage[usStage].initialize(1, true, this.hpFreqHz, 1.0, this.sampleRate);
                ++usStage;
                break;
            }
            case 2: {
                this.stage[usStage].initialize(2, true, this.hpFreqHz, 1.414, this.sampleRate);
                ++usStage;
                break;
            }
            case 3: {
                this.stage[usStage].initialize(1, true, this.hpFreqHz, 1.0, this.sampleRate);
                this.stage[++usStage].initialize(2, true, this.hpFreqHz, 1.0, this.sampleRate);
                ++usStage;
                break;
            }
            case 4: {
                this.stage[usStage].initialize(2, true, this.hpFreqHz, 1.847759, this.sampleRate);
                this.stage[++usStage].initialize(2, true, this.hpFreqHz, 0.7653668, this.sampleRate);
                ++usStage;
                break;
            }
            case 5: {
                this.stage[usStage].initialize(1, true, this.hpFreqHz, 1.0, this.sampleRate);
                this.stage[++usStage].initialize(2, true, this.hpFreqHz, 1.61803, this.sampleRate);
                this.stage[++usStage].initialize(2, true, this.hpFreqHz, 0.61803, this.sampleRate);
                ++usStage;
                break;
            }
        }
        switch (this.lpOrder) {
            case 1: {
                this.stage[usStage].initialize(1, false, this.lpFreqHz, 1.0, this.sampleRate);
                ++usStage;
                break;
            }
            case 2: {
                this.stage[usStage].initialize(2, false, this.lpFreqHz, 1.414, this.sampleRate);
                ++usStage;
                break;
            }
            case 3: {
                this.stage[usStage].initialize(1, false, this.lpFreqHz, 1.0, this.sampleRate);
                this.stage[++usStage].initialize(2, false, this.lpFreqHz, 1.0, this.sampleRate);
                ++usStage;
                break;
            }
            case 4: {
                this.stage[usStage].initialize(2, false, this.lpFreqHz, 1.847759, this.sampleRate);
                this.stage[++usStage].initialize(2, false, this.lpFreqHz, 0.7653668, this.sampleRate);
                ++usStage;
                break;
            }
            case 5: {
                this.stage[usStage].initialize(1, false, this.lpFreqHz, 1.0, this.sampleRate);
                this.stage[++usStage].initialize(2, false, this.lpFreqHz, 1.61803, this.sampleRate);
                this.stage[++usStage].initialize(2, false, this.lpFreqHz, 0.61803, this.sampleRate);
                ++usStage;
                break;
            }
        }
        while (usStage < 3) {
            this.stage[usStage].initialize(0, false, 0.0, 0.0, this.sampleRate);
            ++usStage;
        }
        this.staFilter.initialize(1.0 / (Math.PI * 2 * this.staConst), this.sampleRate);
        this.ltaFilter.initialize(1.0 / (Math.PI * 2 * this.ltaConst), this.sampleRate);
        this.inputLta.initialize(1.0 / (Math.PI * 2 * this.ltaConst), this.sampleRate);
        this.reset();
        this.isInitialized = true;
    }

    private void reset() {
        this.stage[0].reset();
        this.stage[1].reset();
        this.stage[2].reset();
        this.staFilter.reset();
        this.ltaFilter.reset();
        this.inputLta.reset();
        this.ratio = 0.0;
        this.trigState = 0;
        this.samplesToSettleLTA = (int)(this.ltaConst * (double)this.sampleRate);
        this.nextPacketTime = -1.0;
    }

    public void setTriggerTimeout(int newTimeout) {
        timeout = newTimeout;
    }

    public void process(double pktStartTime, int[] theSamples, int numSamples, int pktSampleRate) {
        this.setSampleRate(pktSampleRate);
        if (!this.isInitialized) {
            this.initialize();
        }
        this.packetTime = pktStartTime;
        if ((double)this.sampleRate * Math.abs(this.packetTime - this.nextPacketTime) > 1.0) {
            this.samplesToSettleHP = (int)((double)this.sampleRate * this.findHPSettlingTime());
        }
        this.nextPacketTime = this.packetTime + 1.0 * (double)numSamples / (double)this.sampleRate;
        if (this.trigState > 0) {
            this.setTimeouts();
        }
        this.sampleNum = 0;
        while (this.sampleNum < numSamples) {
            this.processSample(theSamples[this.sampleNum]);
            ++this.sampleNum;
        }
    }

    private double findHPSettlingTime() {
        if (this.hpOrder < 1 || this.hpFreqHz < 0.001) {
            return 0.0;
        }
        double ampRatio = 1.0;
        if (this.samplesToSettleLTA <= 0) {
            ampRatio = this.ltaFilter.getVal() / Math.max(this.inputLta.getVal(), 1.0);
        } else {
            double microFreq = 0.2;
            ampRatio = Math.pow(microFreq / this.hpFreqHz, this.hpOrder);
        }
        ampRatio /= 2.0;
        if (ampRatio > 0.9) {
            return 0.0;
        }
        if (ampRatio < 1.0E-8) {
            ampRatio = 1.0E-8;
        }
        double timeConstant = 1.0 / (Math.PI * 2 * this.hpFreqHz * damping[this.hpOrder]);
        double numTC = -Math.log(ampRatio);
        double settlingTime = numTC * timeConstant;
        return Math.min(settlingTime, 5.0 * this.ltaConst);
    }

    private void checkTriggerState(int lSample, double ratio) {
        if (this.trigState == 0) {
            if (ratio >= this.trigLevel) {
                this.initStates(lSample);
                this.issueTrigger();
                this.setTimeouts();
            }
        } else if (ratio <= 1.0 || this.sampleNum >= this.sampleToTimeout) {
            if (this.trigState == 1) {
                this.issueTrigger();
            }
            this.issueTrigger();
        } else {
            this.updateStates(lSample);
            if (this.trigState == 1 && this.sampleNum >= this.earlyReportSample) {
                this.issueTrigger();
            }
        }
    }

    private void processSample(int lSample) {
        this.inputLta.update(Math.abs(lSample));
        this.stage[0].update(lSample);
        this.stage[1].update(this.stage[0].getVal());
        this.stage[2].update(this.stage[1].getVal());
        if (this.samplesToSettleHP <= 0) {
            this.staFilter.update(Math.abs(this.stage[2].getVal()));
            this.ltaFilter.update(this.staFilter.getVal());
            this.ratio = this.staFilter.getVal() / Math.max(this.ltaFilter.getVal(), 0.01);
            if (this.samplesToSettleLTA <= 0) {
                this.checkTriggerState(lSample, this.ratio);
            } else {
                --this.samplesToSettleLTA;
            }
        } else {
            --this.samplesToSettleHP;
        }
    }

    private void issueTrigger() {
        StaLtaTrigger trigger = new StaLtaTrigger(this.stnid, this.triggerID, this.triggerTime, (float)(this.sampleTime() - this.triggerTime), (float)this.ltaAtStart, (float)this.ltaFilter.getVal(), (float)this.peakSta, this.maxPeakToPeak, (float)(this.startOfMaxPeak - this.triggerTime), (float)(this.endOfMaxPeak - this.startOfMaxPeak), this.trigState);
        Log.report(this, 1, 2, trigger.toString());
        Format ltaFmt = new Format("%.2f");
        Log.report(this, 2, 1, String.valueOf(this.stnid) + " LTA: " + ltaFmt.form(this.ltaFilter.getVal()));
        this.handler.put(trigger);
        ++this.trigState;
        if (this.trigState > 2) {
            this.trigState = 0;
        }
    }

    private double sampleTime() {
        return this.packetTime + (double)this.sampleNum / (double)this.sampleRate;
    }

    public void initStates(int lsampleNum) {
        this.triggerTime = this.sampleTime();
        this.peakSta = this.staFilter.getVal();
        this.ltaAtStart = this.ltaFilter.getVal();
        this.maxPeakToPeak = 0;
        this.startOfMaxPeak = this.triggerTime;
        this.endOfMaxPeak = this.triggerTime;
        this.lastSample = lsampleNum;
        this.lastReversal = lsampleNum;
        this.timeOfLastReversal = this.triggerTime;
        this.direction = 0;
    }

    public void updateStates(int lSample) {
        int newDir = 0;
        if (lSample > this.lastSample) {
            newDir = 1;
        } else if (lSample < this.lastSample) {
            newDir = -1;
        }
        this.lastSample = lSample;
        if (this.direction == 0) {
            this.direction = newDir;
        }
        if (newDir * this.direction >= 0) {
            int lDiff = this.direction * (lSample - this.lastReversal);
            if (lDiff > this.maxPeakToPeak) {
                this.maxPeakToPeak = lDiff;
                this.startOfMaxPeak = this.timeOfLastReversal;
                this.endOfMaxPeak = this.sampleTime();
            }
        } else {
            this.lastReversal = lSample;
            this.timeOfLastReversal = this.sampleTime();
            this.direction = newDir;
        }
        if (this.staFilter.getVal() > this.peakSta) {
            this.peakSta = this.staFilter.getVal();
        }
    }

    public void setTimeouts() {
        if (this.trigState == 1) {
            double rtmEarlyReport = this.triggerTime + this.earlyReportTime;
            double rdEarlyReportSample = (rtmEarlyReport - this.packetTime) * (double)this.sampleRate + 0.5;
            this.earlyReportSample = rdEarlyReportSample < 0.0 ? 0 : (rdEarlyReportSample > 2.147483647E9 ? Integer.MAX_VALUE : (int)rdEarlyReportSample);
        }
        if (this.trigState > 0) {
            double rtmTimeout = this.triggerTime + (double)timeout;
            double rdSampleToTimeout = (rtmTimeout - this.packetTime) * (double)this.sampleRate + 0.5;
            this.sampleToTimeout = rdSampleToTimeout < 0.0 ? 0 : (rdSampleToTimeout > 2.147483647E9 ? Integer.MAX_VALUE : (int)rdSampleToTimeout);
        }
    }
}

