/*
 * Decompiled with CFR 0.152.
 */
import java.util.Arrays;

public class StateMonitor
implements Comparable {
    private String name;
    private int[] timeouts;
    private int maxState;
    private int state;
    private int ticksSincePing;
    private boolean latched;

    public StateMonitor(String componentName, int[] timeoutsInSec) {
        this.name = componentName;
        if (timeoutsInSec == null || timeoutsInSec.length < 1) {
            timeoutsInSec = new int[]{Integer.MAX_VALUE};
        }
        this.timeouts = (int[])timeoutsInSec.clone();
        Arrays.sort(this.timeouts);
        this.maxState = this.timeouts.length;
        this.state = 1;
        this.ticksSincePing = 0;
        this.latched = false;
    }

    public StateMonitor(String componentName, int timeout) {
        this(componentName, new int[]{timeout});
    }

    public int ping() {
        int previous = this.state;
        this.ticksSincePing = 0;
        this.latched = true;
        this.state = 0;
        return previous;
    }

    public int test() {
        ++this.ticksSincePing;
        int previous = this.state;
        if (this.state < this.maxState && this.ticksSincePing > this.timeouts[this.state]) {
            ++this.state;
        }
        return previous;
    }

    public boolean isOnline() {
        return this.state == 0;
    }

    public boolean isLatched() {
        return this.latched;
    }

    public void reset() {
        this.latched = false;
    }

    public int getState() {
        return this.state;
    }

    public int getTimeout(int statenum) {
        if (statenum > 0 && statenum <= this.maxState) {
            return this.timeouts[statenum - 1];
        }
        return 0;
    }

    public int getTimeout() {
        return this.getTimeout(this.state);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return String.valueOf(this.name) + ": S = " + this.state + ", L = " + this.latched + ", T = " + this.ticksSincePing;
    }

    public int compareTo(Object obj) {
        try {
            return this.name.compareTo(((StateMonitor)obj).getName());
        }
        catch (Exception e) {
            return -1;
        }
    }
}

