/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.msg.ChannelList;
import ca.nanometrics.msg.DataAddRequest;
import ca.nanometrics.msg.DataRemoveRequest;
import ca.nanometrics.msg.EventAddRequest;
import ca.nanometrics.msg.EventRemoveRequest;
import ca.nanometrics.msg.MsgClient;
import ca.nanometrics.msg.MsgConsumer;
import ca.nanometrics.msg.SerialAddRequest;
import ca.nanometrics.msg.SerialRemoveRequest;
import ca.nanometrics.msg.SohAddRequest;
import ca.nanometrics.msg.SohRemoveRequest;
import ca.nanometrics.msg.TriggerAddRequest;
import ca.nanometrics.msg.TriggerRemoveRequest;
import ca.nanometrics.packet.ChannelKey;
import ca.nanometrics.packet.Packable;
import ca.nanometrics.util.ConsoleMonitor;
import ca.nanometrics.util.NmxDateFormat;
import ca.nanometrics.util.StringQueue;
import java.io.IOException;
import java.util.Iterator;
import java.util.StringTokenizer;

public class StreamTest {
    private static final String ALL = "all";
    private NmxDateFormat dateFmt = new NmxDateFormat();
    private ChannelList channelList = null;
    private MsgClient naqsClient;
    private boolean stayAlive = true;
    private StringQueue console = ConsoleMonitor.getInputQueue();
    private int currentChannel = 0;

    public StreamTest(String host, int port) throws Exception {
        this.naqsClient = new MsgClient();
        this.naqsClient.connectTo(host, port, false);
        SimpleConsumer consumer = new SimpleConsumer();
        this.naqsClient.addSubscriber(consumer);
    }

    protected String[] makeArgs(String input) {
        if (input == null) {
            return new String[0];
        }
        StringTokenizer st = new StringTokenizer(input);
        int argc = st.countTokens();
        String[] args = new String[argc];
        int ix = 0;
        while (ix < argc) {
            args[ix] = st.nextToken();
            ++ix;
        }
        return args;
    }

    protected void assertChannelListExists() throws IOException {
        if (this.channelList == null) {
            throw new IOException("cannot obtain channel list");
        }
    }

    protected void displayChannelList(String[] args) throws IOException {
        String match = null;
        if (args.length > 1) {
            match = args[1].toLowerCase();
        }
        this.assertChannelListExists();
        System.out.println("channel list contains:");
        Iterator iter = this.channelList.names();
        while (iter.hasNext()) {
            String channelName = (String)iter.next();
            if (match != null && !channelName.toLowerCase().startsWith(match)) continue;
            int key = this.channelList.getKeyOf(channelName);
            System.out.println(String.valueOf(channelName) + " " + ChannelKey.getKeyStringOf(key));
        }
    }

    protected int getChannelKey(String name) throws IOException {
        this.assertChannelListExists();
        return this.channelList.getKeyOf(name.toUpperCase());
    }

    protected void addEvents() {
        System.out.println("adding event subscription");
        this.naqsClient.send(new EventAddRequest(new int[0]));
    }

    protected void removeEvents() {
        System.out.println("removing event subscription");
        this.naqsClient.send(new EventRemoveRequest(new int[0]));
    }

    protected void addTriggers() {
        System.out.println("adding trigger subscription");
        this.naqsClient.send(new TriggerAddRequest(new int[0]));
    }

    protected void removeTriggers() {
        System.out.println("removing trigger subscription");
        this.naqsClient.send(new TriggerRemoveRequest(new int[0]));
    }

    protected void addSoh(String[] args) throws IOException {
        System.out.println("addSoh");
        if (args.length > 3) {
            String channelName = args[1];
            int key = this.getChannelKey(channelName);
            if (key == -1) {
                System.out.println("channel not found: " + channelName);
                return;
            }
            if (ChannelKey.getTypeOf(key) != 2) {
                System.out.println("not an SOH channel: " + channelName);
                return;
            }
            int maxDelay = Integer.parseInt(args[2]);
            boolean wantbuff = Integer.parseInt(args[3]) != 0;
            System.out.println("getting soh for " + channelName + " with maxDelay = " + maxDelay + " and buff = " + wantbuff);
            int[] keys = new int[]{key};
            this.naqsClient.send(new SohAddRequest(keys, maxDelay, wantbuff));
        } else {
            System.out.println("usage:  addSoh channelName maxDelay wantsBuff");
        }
    }

    protected void removeSoh(String[] args) throws IOException {
        if (args.length > 1) {
            String channelName = args[1];
            int key = this.getChannelKey(channelName);
            if (key == -1) {
                System.out.println("channel not found: " + channelName);
                return;
            }
            if (ChannelKey.getTypeOf(key) != 2) {
                System.out.println("not an SOH channel: " + channelName);
                return;
            }
            System.out.println("removing subscription for " + channelName);
            int[] keys = new int[]{key};
            this.naqsClient.send(new SohRemoveRequest(keys));
        } else {
            System.out.println("usage:  rmSoh channelName");
        }
    }

    protected void addSerial(String[] args) throws IOException {
        if (args.length > 3) {
            String channelName = args[1];
            int key = this.getChannelKey(channelName);
            if (key == -1) {
                System.out.println("channel not found: " + channelName);
                return;
            }
            if (ChannelKey.getTypeOf(key) != 6) {
                System.out.println("not a serial channel: " + channelName);
                return;
            }
            int maxDelay = Integer.parseInt(args[2]);
            boolean wantbuff = Integer.parseInt(args[3]) != 0;
            System.out.println("getting serial data for " + channelName + " with maxDelay = " + maxDelay + " and buff = " + wantbuff);
            int[] keys = new int[]{key};
            this.naqsClient.send(new SerialAddRequest(keys, maxDelay, wantbuff));
        } else {
            System.out.println("usage:  addSer channelName maxDelay wantsBuff");
        }
    }

    protected void removeSerial(String[] args) throws IOException {
        if (args.length > 1) {
            String channelName = args[1];
            int key = this.getChannelKey(channelName);
            if (key == -1) {
                System.out.println("channel not found: " + channelName);
                return;
            }
            if (ChannelKey.getTypeOf(key) != 6) {
                System.out.println("not a serial channel: " + channelName);
                return;
            }
            System.out.println("removing subscription for " + channelName);
            int[] keys = new int[]{key};
            this.naqsClient.send(new SerialRemoveRequest(keys));
        } else {
            System.out.println("usage:  rmSer channelName");
        }
    }

    protected void addTimeSeries(String[] args) throws IOException {
        if (args.length > 4) {
            String channelName = args[1];
            int key = this.getChannelKey(channelName);
            if (key == -1) {
                System.out.println("channel not found: " + channelName);
                return;
            }
            if (ChannelKey.getTypeOf(key) != 1) {
                System.out.println("not a time series channel: " + channelName);
                return;
            }
            int maxDelay = Integer.parseInt(args[2]);
            int format = Integer.parseInt(args[3]);
            boolean wantbuff = Integer.parseInt(args[4]) != 0;
            System.out.println("getting data for " + channelName + " with maxDelay = " + maxDelay + " format = " + format + " and buff = " + wantbuff);
            int[] keys = new int[]{key};
            this.naqsClient.send(new DataAddRequest(keys, maxDelay, format, wantbuff));
        } else {
            System.out.println("usage:  addts channelName maxDelay format wantsBuff");
        }
    }

    protected void removeTimeSeries(String[] args) throws IOException {
        if (args.length > 1) {
            String channelName = args[1];
            int key = this.getChannelKey(channelName);
            if (key == -1) {
                System.out.println("channel not found: " + channelName);
                return;
            }
            if (ChannelKey.getTypeOf(key) != 1) {
                System.out.println("not a time series channel: " + channelName);
                return;
            }
            System.out.println("removing subscription for " + channelName);
            int[] keys = new int[]{key};
            this.naqsClient.send(new DataRemoveRequest(keys));
        } else {
            System.out.println("usage:  rmts channelName");
        }
    }

    protected void showHelp() throws IOException {
        System.out.println("The following commands are supported:");
        System.out.println();
        System.out.println("  list        - get channel list");
        System.out.println();
        System.out.println("  addtrigs    - add trigger subscription");
        System.out.println("  addevent    - add event subscription");
        System.out.println("  addsoh chan - add soh subscription");
        System.out.println("  addser chan - add serial subscription");
        System.out.println("  addts  chan - add data subscription");
        System.out.println();
        System.out.println("  rmtrigs     - remove trigger subscription");
        System.out.println("  rmevent     - remove event subscription");
        System.out.println("  rmsoh chan  - remove soh subscription");
        System.out.println("  rmser chan  - remove serial subscription");
        System.out.println("  rmts  chan  - remove data subscription");
        System.out.println();
        System.out.println("  quit    - quit this program");
    }

    protected void processCmd(String[] args) throws IOException {
        String cmd = args[0].toLowerCase();
        if (cmd.equals("list")) {
            this.displayChannelList(args);
        } else if (cmd.equals("addtrigs")) {
            this.addTriggers();
        } else if (cmd.equals("rmtrigs")) {
            this.removeTriggers();
        } else if (cmd.equals("addevent")) {
            this.addEvents();
        } else if (cmd.equals("rmevent")) {
            this.removeEvents();
        } else if (cmd.equals("addsoh")) {
            this.addSoh(args);
        } else if (cmd.equals("rmsoh")) {
            this.removeSoh(args);
        } else if (cmd.equals("addser")) {
            this.addSerial(args);
        } else if (cmd.equals("rmser")) {
            this.removeSerial(args);
        } else if (cmd.equals("addts")) {
            this.addTimeSeries(args);
        } else if (cmd.equals("rmts")) {
            this.removeTimeSeries(args);
        } else if (cmd.equals("quit") || cmd.equals("q")) {
            System.out.println("quitting... goodbye");
            this.stayAlive = false;
        } else if (cmd.equals("help") || cmd.equals("h")) {
            this.showHelp();
        } else {
            System.out.println("unknown command " + cmd);
            System.out.println("type help for help");
        }
    }

    public void go() {
        this.stayAlive = true;
        this.naqsClient.start();
        System.out.print(">");
        while (this.stayAlive) {
            try {
                String input = this.console.get(100);
                if (input == null) continue;
                if ((input = input.trim()).length() > 0) {
                    this.processCmd(this.makeArgs(input));
                }
                if (!this.stayAlive) continue;
                System.out.print(">");
            }
            catch (InterruptedException input) {
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            catch (Exception any) {
                any.printStackTrace();
            }
        }
        this.naqsClient.stop();
    }

    public static void main(String[] args) {
        System.out.println("StreamTest - test program for Naqs Datastream Service");
        System.out.println("copyright (C) Nanometrics, Inc., 2003");
        String host = "localhost";
        int port = 28100;
        if (args.length > 0 && args[0].startsWith("-")) {
            System.out.println("usage: StreamTest [host [port]]");
            System.exit(0);
        }
        if (args.length > 0) {
            host = args[0];
        }
        if (args.length > 1) {
            port = Integer.parseInt(args[1]);
        }
        System.out.println("Connecting to " + host + ":" + port);
        try {
            StreamTest instance = new StreamTest(host, port);
            instance.go();
        }
        catch (Exception any) {
            System.out.println("Error initializing application:");
            any.printStackTrace();
        }
    }

    public class SimpleConsumer
    implements MsgConsumer {
        public void put(Packable packet) {
            if (packet instanceof ChannelList) {
                StreamTest.this.channelList = (ChannelList)packet;
            } else {
                System.out.println("rx " + packet);
            }
        }
    }
}

