/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.packet.EventHandler;
import ca.nanometrics.packet.EventPacket;
import ca.nanometrics.packet.NmxPacket;
import ca.nanometrics.packet.NmxPacketHandler;
import ca.nanometrics.packet.TriggerHandler;
import ca.nanometrics.packet.TriggerPacket;
import ca.nanometrics.util.Log;
import java.util.Iterator;
import java.util.LinkedList;

public class SubscriberList
implements NmxPacketHandler,
TriggerHandler,
EventHandler {
    private LinkedList subscribers = new LinkedList();

    public synchronized void add(DSSubscriber subscriber) {
        if (subscriber != null) {
            this.subscribers.add(subscriber);
        }
    }

    public int size() {
        return this.subscribers.size();
    }

    public void list() {
        int ix = 0;
        Iterator iter = this.subscribers.iterator();
        while (iter.hasNext()) {
            DSSubscriber subscriber = (DSSubscriber)iter.next();
            Log.report(this, 0, 2, "Subscriber " + ++ix + ": " + subscriber);
        }
    }

    public synchronized void removeDeadSubscribers() {
        Iterator iter = this.subscribers.iterator();
        while (iter.hasNext()) {
            DSSubscriber subscriber = (DSSubscriber)iter.next();
            if (subscriber.isAlive()) continue;
            iter.remove();
        }
    }

    public synchronized void closeAll() {
        Iterator iter = this.subscribers.iterator();
        while (iter.hasNext()) {
            DSSubscriber subscriber = (DSSubscriber)iter.next();
            subscriber.stop();
            iter.remove();
        }
    }

    public void put(NmxPacket packet) {
        Iterator iter = this.subscribers.iterator();
        while (iter.hasNext()) {
            DSSubscriber subscriber = (DSSubscriber)iter.next();
            subscriber.put(packet);
        }
    }

    public void put(TriggerPacket packet) {
        Iterator iter = this.subscribers.iterator();
        while (iter.hasNext()) {
            DSSubscriber subscriber = (DSSubscriber)iter.next();
            subscriber.put(packet);
        }
    }

    public void put(EventPacket packet) {
        Iterator iter = this.subscribers.iterator();
        while (iter.hasNext()) {
            DSSubscriber subscriber = (DSSubscriber)iter.next();
            subscriber.put(packet);
        }
    }
}

