/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.packet.StaLtaTrigger;
import ca.nanometrics.util.NmxDateFormat;

class TriggerInfo {
    private double startTime;
    private double endTime = 0.0;
    private double peakRatio;
    private String name;
    private NmxDateFormat format;

    public TriggerInfo(StaLtaTrigger trig) {
        this.name = trig.getStnID();
        this.startTime = trig.getStartTime();
        this.peakRatio = trig.getPeakRatio();
        this.format = new NmxDateFormat("HH:mm:ss.SSS");
    }

    public void setEnd(StaLtaTrigger trig) {
        this.endTime = this.startTime + (double)trig.getDuration();
        this.peakRatio = trig.getPeakRatio();
    }

    public double getStartTime() {
        return this.startTime;
    }

    public double getEndTime() {
        return this.endTime;
    }

    public double getPeakRatio() {
        return this.peakRatio;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object obj) {
        try {
            TriggerInfo trig = (TriggerInfo)obj;
            return trig.getName().equals(this.name) && trig.getStartTime() == this.startTime;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean sameChannelAs(TriggerInfo trig) {
        try {
            return trig.getName().equals(this.name);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isComplete() {
        return this.endTime > 0.0;
    }

    public String toString() {
        String retString = new String(String.valueOf(this.name) + ": " + this.format.format(this.startTime) + "  " + this.format.format(this.endTime));
        return retString;
    }
}

