/*
 * Decompiled with CFR 0.152.
 */
import ca.nanometrics.packet.StaLtaTrigger;
import ca.nanometrics.util.Log;
import java.util.Enumeration;
import java.util.Vector;

class TriggerTimeTable {
    private Vector triggers = new Vector(20, 10);
    private int trigsToStart;
    private int coincWindow;
    private int maxTrigAge;

    public TriggerTimeTable(int trigsForEvent, int windowSecs, int maxDelaySecs) {
        this.trigsToStart = trigsForEvent;
        this.coincWindow = windowSecs;
        this.maxTrigAge = this.coincWindow + maxDelaySecs;
    }

    public void addTrigger(StaLtaTrigger trig) {
        long oldestToKeep = System.currentTimeMillis() / 1000L - (long)this.maxTrigAge;
        TriggerInfo info = new TriggerInfo(trig);
        int position = 0;
        Enumeration e = this.triggers.elements();
        while (e.hasMoreElements()) {
            TriggerInfo nextTrigger = (TriggerInfo)e.nextElement();
            if (nextTrigger.equals(info) && !nextTrigger.isComplete()) {
                nextTrigger.setEnd(trig);
                if (nextTrigger.getStartTime() < (double)oldestToKeep) {
                    this.triggers.removeElementAt(position);
                }
                Log.report(this, 1, 0, "Added trigger off: " + trig.toString());
                return;
            }
            if (info.getStartTime() < nextTrigger.getStartTime() && trig.getPhase() == 0) {
                this.triggers.insertElementAt(info, position);
                Log.report(this, 4, 0, "Added " + trig.toString());
                return;
            }
            ++position;
        }
        if (trig.getPhase() == 0) {
            this.triggers.addElement(info);
            Log.report(this, 5, 0, "Added " + trig.toString());
        } else {
            Log.report(this, 6, 0, "No corresponding on message.");
        }
    }

    public synchronized void removeMature() {
        long oldestToKeep = System.currentTimeMillis() / 1000L - (long)this.maxTrigAge;
        Enumeration e = this.triggers.elements();
        while (e.hasMoreElements()) {
            TriggerInfo nextElement = (TriggerInfo)e.nextElement();
            if (!(nextElement.getStartTime() < (double)oldestToKeep)) break;
            this.triggers.removeElement(nextElement);
            Log.report(this, 7, 0, "Removed " + nextElement.toString());
        }
    }

    private TriggerInfo[] checkForRepeats(int startIndex, int endIndex) {
        TriggerInfo[] coinTrigs = new TriggerInfo[endIndex - startIndex + 1];
        int arrayIndex = endIndex - startIndex;
        int repeats = 0;
        int i = endIndex;
        while (i >= startIndex) {
            TriggerInfo next = (TriggerInfo)this.triggers.elementAt(i);
            if (next.isComplete()) {
                int j = arrayIndex + 1;
                while (j <= endIndex - startIndex) {
                    if (coinTrigs[j] != null && coinTrigs[j].sameChannelAs(next)) {
                        coinTrigs[j] = null;
                        ++repeats;
                    }
                    ++j;
                }
            }
            coinTrigs[arrayIndex--] = next;
            --i;
        }
        if (coinTrigs.length - repeats < this.trigsToStart) {
            Log.report(this, 10, 0, "Repeated channels in coincidence window.");
            return null;
        }
        TriggerInfo[] retTrigs = new TriggerInfo[endIndex - startIndex + 1 - repeats];
        int nextRetTrig = 0;
        int i2 = 0;
        while (i2 < coinTrigs.length) {
            if (coinTrigs[i2] != null) {
                retTrigs[nextRetTrig++] = coinTrigs[i2];
            }
            ++i2;
        }
        return retTrigs;
    }

    public synchronized TriggerInfo[] associateTrigs() {
        int startIndex = 0;
        int endIndex = 0;
        Enumeration e = this.triggers.elements();
        while (e.hasMoreElements()) {
            TriggerInfo[] retTrigs;
            TriggerInfo startTrig = (TriggerInfo)e.nextElement();
            int i = endIndex + 1;
            while (i < this.triggers.size()) {
                TriggerInfo endTrig = (TriggerInfo)this.triggers.elementAt(i);
                if (endTrig.getStartTime() > startTrig.getStartTime() + (double)this.coincWindow) break;
                ++endIndex;
                ++i;
            }
            if (endIndex - startIndex >= this.trigsToStart - 1 && (retTrigs = this.checkForRepeats(startIndex, endIndex)) != null) {
                int i2 = 0;
                while (i2 < endIndex - startIndex + 1) {
                    this.triggers.removeElementAt(startIndex);
                    ++i2;
                }
                Log.report(this, 8, 0, "Removed " + (endIndex - startIndex + 1) + " triggers.");
                Log.report(this, 9, 0, "Returned " + retTrigs.length + " triggers.");
                return retTrigs;
            }
            ++startIndex;
        }
        return null;
    }
}

