/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.acq;

import ca.nanometrics.acq.DataRbfReader;
import ca.nanometrics.acq.YFile;
import ca.nanometrics.packet.DecompDataPacket;
import java.io.IOException;

public class Naqs32DataRbfReader
implements DataRbfReader {
    public int handle = 0;
    public int currentXBlockIndex = -1;
    public int currentXBlockHandle = 0;
    public int numberOfXBlocksRead = 0;
    boolean firstCall = true;
    DecompDataPacket currentPacket;
    boolean leftOver = false;
    int calling = 0;
    public int packetNumberInThisXBlock;

    static {
        System.loadLibrary("nmxlvjni");
    }

    public long getStartTime() {
        long tailIndex;
        long headIndex = this.getHeadIndex();
        if (headIndex == (tailIndex = this.getTailIndex()) && tailIndex == 0L) {
            return 0L;
        }
        int first = this.isFull() ? (int)this.getTailIndex() : (int)headIndex;
        int xBlockHandle = this.newXBlock();
        this.extractXBlock(xBlockHandle, first);
        long startTimeOfThisBlock = (long)this.getStartTimeOfThisXBlock(xBlockHandle);
        this.freeXBlock(xBlockHandle);
        return startTimeOfThisBlock;
    }

    public long getEndTime() {
        long headIndex = this.getHeadIndex();
        long tailIndex = this.getTailIndex();
        long maxIndex = this.getMaxIndex();
        if (headIndex == tailIndex && tailIndex == 0L) {
            return 0L;
        }
        int xBlockHandle = this.newXBlock();
        long indexOfLast = tailIndex - 1L;
        if (indexOfLast < 0L) {
            indexOfLast = maxIndex;
        }
        this.extractXBlock(xBlockHandle, indexOfLast);
        long endTimeOfThisBlock = (long)this.getEndTimeOfThisXBlock(xBlockHandle);
        this.freeXBlock(xBlockHandle);
        return endTimeOfThisBlock;
    }

    public int getNumberOfXBlocks() {
        long headIndex = this.getHeadIndex();
        long tailIndex = this.getTailIndex();
        long maxIndex = this.getMaxIndex();
        if (headIndex == tailIndex && tailIndex == 0L) {
            return 0;
        }
        if (headIndex == 0L && headIndex < tailIndex && tailIndex <= maxIndex) {
            return (int)tailIndex;
        }
        return (int)maxIndex + 1;
    }

    public int getFirstXBlock() {
        if (this.getNumberOfXBlocks() == 0) {
            return 0;
        }
        if (this.numberOfXBlocksRead == this.getNumberOfXBlocks()) {
            return 0;
        }
        this.currentXBlockIndex = (long)this.getNumberOfXBlocks() == this.getMaxIndex() + 1L ? (int)this.getTailIndex() : (int)this.getHeadIndex();
        this.numberOfXBlocksRead = 1;
        int xBlockHandle = this.newXBlock();
        this.extractXBlock(xBlockHandle, this.currentXBlockIndex);
        if (this.currentXBlockHandle != 0) {
            this.freeXBlock(this.currentXBlockHandle);
        }
        ++this.currentXBlockIndex;
        if ((long)this.currentXBlockIndex > this.getMaxIndex()) {
            this.currentXBlockIndex = 0;
        }
        this.currentXBlockHandle = xBlockHandle;
        return xBlockHandle;
    }

    public int getNextXBlock() {
        if (this.getNumberOfXBlocks() == 0) {
            return 0;
        }
        if (this.numberOfXBlocksRead == this.getNumberOfXBlocks()) {
            return 0;
        }
        ++this.numberOfXBlocksRead;
        int xBlockHandle = this.newXBlock();
        if (this.currentXBlockHandle != 0) {
            this.freeXBlock(this.currentXBlockHandle);
        }
        this.currentXBlockHandle = xBlockHandle;
        this.extractXBlock(xBlockHandle, this.currentXBlockIndex);
        ++this.currentXBlockIndex;
        if ((long)this.currentXBlockIndex > this.getMaxIndex()) {
            this.currentXBlockIndex = 0;
        }
        return xBlockHandle;
    }

    public int getPreviousXBlock() {
        if (this.getNumberOfXBlocks() == 0) {
            return 0;
        }
        --this.numberOfXBlocksRead;
        int xBlockHandle = this.newXBlock();
        if (this.currentXBlockHandle != 0) {
            this.freeXBlock(this.currentXBlockHandle);
        }
        this.currentXBlockHandle = xBlockHandle;
        --this.currentXBlockIndex;
        if (this.currentXBlockIndex < 0) {
            this.currentXBlockIndex = (int)this.getMaxIndex();
        }
        --this.currentXBlockIndex;
        if (this.currentXBlockIndex < 0) {
            this.currentXBlockIndex = (int)this.getMaxIndex();
        }
        this.extractXBlock(xBlockHandle, this.currentXBlockIndex);
        return xBlockHandle;
    }

    public native long getHeadIndex();

    public native long getTailIndex();

    public native long getMaxIndex();

    private native int readYFileHeader();

    public YFile getYFileHeader() throws IOException {
        int yfl = this.readYFileHeader();
        if (yfl != 0) {
            return new YFile(yfl);
        }
        throw new IOException("error reading YFile header");
    }

    public void finalize() {
        this.closeRingBuffer();
        if (this.currentXBlockHandle != 0) {
            this.freeXBlock(this.currentXBlockHandle);
        }
    }

    public boolean isOpen() {
        return this.handle != 0;
    }

    public native int openRingBuffer(String var1);

    public native int closeRingBuffer();

    public native int newXBlock();

    public native void freeXBlock(int var1);

    public native boolean extractXBlock(int var1, long var2);

    public native double getStartTimeOfThisXBlock(int var1);

    public native double getEndTimeOfThisXBlock(int var1);

    public native double getNumberOfSamplesOfThisXBlock(int var1);

    public native double getSampleRateOfThisXBlock(int var1);

    public native int[] getSamplesOfThisXBlock(int var1);

    public DecompDataPacket extractFirstDataPacket(long stratTime, long endTime) {
        int xBlockHandle;
        if (this.firstCall) {
            this.firstCall = false;
            xBlockHandle = this.getFirstXBlock();
        } else {
            xBlockHandle = this.currentXBlockHandle;
        }
        if (xBlockHandle == 0) {
            return null;
        }
        double startTimeOfThisXBlock = this.getStartTimeOfThisXBlock(xBlockHandle);
        double endTimeOfThisXBlock = this.getEndTimeOfThisXBlock(xBlockHandle);
        while (endTimeOfThisXBlock <= (double)stratTime) {
            xBlockHandle = this.getNextXBlock();
            if (xBlockHandle == 0) {
                return null;
            }
            endTimeOfThisXBlock = this.getEndTimeOfThisXBlock(xBlockHandle);
            startTimeOfThisXBlock = this.getStartTimeOfThisXBlock(xBlockHandle);
        }
        if (startTimeOfThisXBlock >= (double)endTime) {
            return null;
        }
        int numberOfSamples = (int)this.getNumberOfSamplesOfThisXBlock(xBlockHandle);
        int sampleRate = (int)this.getSampleRateOfThisXBlock(xBlockHandle);
        int[] samples = this.getSamplesOfThisXBlock(xBlockHandle);
        DecompDataPacket ret = new DecompDataPacket(0, startTimeOfThisXBlock, samples, samples.length, sampleRate);
        return ret;
    }

    public DecompDataPacket extractNextDataPacket(long startTime, long endTime) {
        double endTimeOfCurrentXBlock = this.getEndTimeOfThisXBlock(this.currentXBlockHandle);
        if ((double)endTime <= endTimeOfCurrentXBlock) {
            return null;
        }
        this.currentXBlockHandle = this.getNextXBlock();
        int xBlockHandle = this.currentXBlockHandle;
        if (xBlockHandle == 0) {
            return null;
        }
        double startTimeOfThisXBlock = this.getStartTimeOfThisXBlock(xBlockHandle);
        double endTimeOfThisXBlock = this.getEndTimeOfThisXBlock(xBlockHandle);
        if (startTimeOfThisXBlock >= (double)endTime) {
            return null;
        }
        int numberOfSamples = (int)this.getNumberOfSamplesOfThisXBlock(xBlockHandle);
        int sampleRate = (int)this.getSampleRateOfThisXBlock(xBlockHandle);
        int[] samples = this.getSamplesOfThisXBlock(xBlockHandle);
        DecompDataPacket ret = new DecompDataPacket(0, startTimeOfThisXBlock, samples, samples.length, sampleRate);
        return ret;
    }

    public boolean isFull() {
        long headIndex = this.getHeadIndex();
        long tailIndex = this.getTailIndex();
        long maxIndex = this.getMaxIndex();
        if (headIndex == tailIndex && tailIndex == 0L) {
            return false;
        }
        return headIndex != 0L || headIndex >= tailIndex || tailIndex > maxIndex;
    }

    public static void main(String[] argus) throws IOException {
        Naqs32DataRbfReader reader = new Naqs32DataRbfReader();
        int ret = reader.openRingBuffer("s01bbe.rbf");
        int numberOfXBlocks = reader.getNumberOfXBlocks();
        boolean full = reader.isFull();
        long headIndex = reader.getHeadIndex();
        long tailIndex = reader.getTailIndex();
        long maxIndex = reader.getMaxIndex();
        YFile yFile = reader.getYFileHeader();
        String getNetworkID = yFile.getNetworkID();
        long startTime = reader.getStartTime();
        long endTime = reader.getEndTime();
        DecompDataPacket packet = reader.extractFirstDataPacket(startTime, endTime);
        int packetNumber = 0;
        while (packet != null) {
            try {
                System.out.print(" Sample Number in Packet " + packet.getNumSamples());
                System.out.print("Packet Number " + ++packetNumber);
                System.out.print("StartTime: " + packet.getStartTime());
                System.out.println("EndTime: " + ((double)packet.getNumSamples() / (double)packet.getSampleRate() + packet.getStartTime()));
                System.out.println("duration of P: " + ((double)packet.getNumSamples() / (double)packet.getSampleRate() + packet.getStartTime() - packet.getStartTime()));
                packet = reader.extractNextDataPacket(startTime, endTime);
            }
            catch (Exception e) {
                System.out.println("Exception occured!!!");
            }
        }
        ret = reader.closeRingBuffer();
    }
}

