/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.acq;

import ca.nanometrics.acq.YFile;
import java.io.IOException;

public class RbfWrapper {
    static final int SOH_LABEL_SIZE = 17;
    static final int BUNDLE_SIZE = 17;
    static final int TAG_PACKET_RINGBUFFER = 43;
    static final int TAG_PACKET_SOHBUFFER = 44;
    public int handle = 0;

    static {
        System.loadLibrary("nmxqjni");
    }

    private native int readYFileHeader();

    public YFile getYFileHeader() throws IOException {
        int yfl = this.readYFileHeader();
        if (yfl != 0) {
            return new YFile(yfl);
        }
        throw new IOException("error reading YFile header");
    }

    public void finalize() {
        this.closeRingBuffer();
    }

    public boolean isOpen() {
        return this.handle != 0;
    }

    public int createRingBuffer(String fileName, int size, int serialNumber, int packetSize, int yflHeader, boolean isDataFile) {
        int fileTag = isDataFile ? 43 : 44;
        return this.createRingBuffer(fileName, size, serialNumber, packetSize, yflHeader, fileTag);
    }

    public native int createRingBuffer(String var1, int var2, int var3, int var4, int var5, int var6);

    public int openRingBuffer(String fileName, boolean isDataFile) {
        int fileTag = isDataFile ? 43 : 44;
        return this.openRingBuffer(fileName, fileTag);
    }

    public native int openRingBuffer(String var1, int var2);

    public native int closeRingBuffer();

    public native int resetRingBuffer();

    public native int getPacketSize();

    public native int getPacketCount();

    public native int getLastExtracted();

    public native int setWrap(boolean var1);

    public native int setAppendBuffer(int var1, int var2);

    public native int setInsertBuffer(int var1);

    public native int flushAppendBuffer();

    public native int flushInsertBuffer();

    public native int setReadBuffer(int var1);

    public native int setIndexBuffer(int var1);

    public native int addPacket(byte[] var1);

    public native int insertPacket(byte[] var1, int var2);

    public native int readInfo();

    public native long getStartTime();

    public long getEndTime() {
        return this.getIndexTime(this.getNewestEntry());
    }

    private native int readPacket(byte[] var1, int var2);

    public byte[] getPacket(int index) {
        byte[] packet = new byte[this.getPacketSize()];
        if (this.readPacket(packet, index) == 0) {
            return packet;
        }
        return null;
    }

    private native int readNextPacket(byte[] var1);

    public byte[] getNextPacket() {
        byte[] packet = new byte[this.getPacketSize()];
        if (this.readNextPacket(packet) == 0) {
            return packet;
        }
        return null;
    }

    private native int findFirstPacket(byte[] var1, long var2, long var4);

    public byte[] extractFirstPacket(long startTime, long endTime) {
        byte[] packet = new byte[this.getPacketSize()];
        if (this.findFirstPacket(packet, startTime, endTime) == 0) {
            return packet;
        }
        return null;
    }

    private native int findNextPacket(byte[] var1, long var2, long var4);

    public byte[] extractNextPacket(long startTime, long endTime) {
        byte[] packet = new byte[this.getPacketSize()];
        if (this.findNextPacket(packet, startTime, endTime) == 0) {
            return packet;
        }
        return null;
    }

    public native long getIndexTime(int var1);

    public native int addSohLabel(int var1, byte[] var2);

    private native int readSohLabel(int var1, byte[] var2);

    public byte[] getSohLabel(int channel) {
        byte[] label = new byte[17];
        if (this.readSohLabel(channel, label) == 0) {
            return label;
        }
        return null;
    }

    public native int addSohCal(byte[] var1);

    private native int readSohCal(int var1, byte[] var2);

    public byte[] getSohCalBundle(int channel) {
        byte[] bundle = new byte[17];
        if (this.readSohCal(channel, bundle) == 0) {
            return bundle;
        }
        return null;
    }

    public native int newestSequence();

    public native int getNewestEntry();

    public native int getOldestEntry();

    public native int getMaxEntry();
}

