/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.acq;

import ca.nanometrics.util.Log;
import ca.nanometrics.util.Stoppable;

public class Watchdog
implements Runnable {
    public static final int WDG_ALARM_NAQS_MASK = 7;
    public static final int WDG_ALARM_NAQS_GREEN = 4;
    public static final int WDG_ALARM_NAQS_YELLOW = 2;
    public static final int WDG_ALARM_NAQS_RED = 1;
    public static final int WDG_ALARM_CIDA_MASK = 63;
    public static final int WDG_ALARM_GREEN_LIGHT = 20;
    public static final int WDG_ALARM_YELLOW_LIGHT = 34;
    public static final int WDG_ALARM_RED_LIGHT = 57;
    public static final int WDG_ALARM_EVENT_MASK = 56;
    public static final int WDG_ALARM_EVENT_RED = 8;
    public static final int WDG_ALARM_EVENT_YELLOW = 16;
    public static final int WDG_ALARM_EVENT_SOUND = 32;
    private static Watchdog singleton = null;
    private int hwdg;
    private Stoppable app = null;
    private Thread shutdownMonitor = null;

    static {
        System.loadLibrary("nmxqjni");
    }

    public Watchdog() {
        this.open();
    }

    public static Watchdog getWatchdog() {
        if (singleton == null) {
            singleton = new Watchdog();
        }
        return singleton;
    }

    public void finalize() {
        this.close();
    }

    public boolean isOpen() {
        return this.hwdg != 0;
    }

    private native void open();

    private native void close();

    public native void hitWatchdog();

    public native int sendAlarm(int var1, int var2);

    private native boolean monitorKillEvent();

    public void startShutdownMonitor() {
        this.startShutdownMonitor(null);
    }

    public synchronized void startShutdownMonitor(Stoppable stoppable) {
        this.app = stoppable;
        if (this.shutdownMonitor == null || !this.shutdownMonitor.isAlive()) {
            this.shutdownMonitor = new Thread(this);
            this.shutdownMonitor.setDaemon(true);
            this.shutdownMonitor.start();
        }
    }

    private synchronized void shutdown() {
        Log.report(this, 1, 3, "Received shutdown message");
        if (this.app != null) {
            this.app.stop();
        }
        System.exit(0);
    }

    public void run() {
        if (this.monitorKillEvent()) {
            this.shutdown();
        }
        this.shutdownMonitor = null;
    }
}

