/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.alert;

import ca.nanometrics.packet.Packable;
import ca.nanometrics.util.BigEndian;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.util.NmxDateFormat;
import java.util.StringTokenizer;

public class AlertMessage
implements Packable {
    public static final int MSG_TYPE = 320;
    static final int TIME_LEN = 8;
    static final int SEVERITY_LEN = 4;
    static final int STRLEN_LEN = 2;
    private long msgTime = 0L;
    private int severity = 0;
    private String sourceId;
    private String classId;
    private String format;
    private String arguments;

    public AlertMessage(String mSource, String mClass, int mSeverity, String mFormat, String mArgs) {
        this.sourceId = this.notNull(mSource);
        this.classId = this.notNull(mClass);
        this.format = this.notNull(mFormat);
        this.arguments = this.notNull(mArgs);
        this.severity = mSeverity;
        this.msgTime = System.currentTimeMillis();
    }

    public AlertMessage(String mSource, String mClass, int mSeverity, String mFormat) {
        this(mSource, mClass, mSeverity, mFormat, "");
    }

    public AlertMessage(byte[] buffer, int offset, int length) throws InvalidInputException {
        this.readFrom(buffer, offset, length);
    }

    private String notNull(String arg) {
        if (arg != null) {
            return arg;
        }
        return "";
    }

    public void setFormat(String mFormat) {
        this.format = this.notNull(mFormat);
    }

    public long getMsgTimeMillis() {
        return this.msgTime;
    }

    public double getMsgTimeSecs() {
        return 0.001 * (double)this.msgTime;
    }

    public int getSeverity() {
        return this.severity;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public String getClassId() {
        return this.classId;
    }

    public String getFormat() {
        return this.format;
    }

    public String getArgString() {
        return this.arguments;
    }

    public int getDataType() {
        return 320;
    }

    public int getDataLength() {
        return 20 + this.sourceId.length() + this.classId.length() + this.format.length() + this.arguments.length();
    }

    public void writeTo(byte[] buffer, int offset) {
        BigEndian.writeInt(buffer, offset, this.severity);
        BigEndian.writeLong(buffer, offset += 4, this.msgTime);
        offset += 8;
        offset += this.writeString(buffer, offset, this.sourceId);
        offset += this.writeString(buffer, offset, this.classId);
        offset += this.writeString(buffer, offset, this.format);
        offset += this.writeString(buffer, offset, this.arguments);
    }

    private int writeString(byte[] buffer, int offset, String s) {
        byte[] barray = s.getBytes();
        int blength = barray.length;
        BigEndian.writeShort(buffer, offset, (short)blength);
        System.arraycopy(barray, 0, buffer, offset + 2, blength);
        return blength + 2;
    }

    private byte[] readString(byte[] buffer, int offset) {
        short length = BigEndian.readShort(buffer, offset);
        byte[] barray = new byte[length];
        System.arraycopy(buffer, offset + 2, barray, 0, length);
        return barray;
    }

    public void readFrom(byte[] buffer, int offset, int length) throws InvalidInputException {
        try {
            int bytesRead = 0;
            this.severity = BigEndian.readInt(buffer, offset + bytesRead);
            this.msgTime = BigEndian.readLong(buffer, offset + (bytesRead += 4));
            byte[] barray = this.readString(buffer, offset + (bytesRead += 8));
            bytesRead += 2 + barray.length;
            this.sourceId = new String(barray);
            barray = this.readString(buffer, offset + bytesRead);
            bytesRead += 2 + barray.length;
            this.classId = new String(barray);
            barray = this.readString(buffer, offset + bytesRead);
            bytesRead += 2 + barray.length;
            this.format = new String(barray);
            barray = this.readString(buffer, offset + bytesRead);
            this.arguments = new String(barray);
            if ((bytesRead += 2 + barray.length) > length) {
                throw new InvalidInputException("readFrom: insufficient data.");
            }
        }
        catch (Exception e) {
            throw new InvalidInputException("readFrom: insufficient data.");
        }
    }

    public String[] getArguments() {
        if (this.arguments.length() <= 0) {
            return new String[0];
        }
        String delim = this.arguments.substring(0, 1);
        StringTokenizer st = new StringTokenizer(this.arguments, delim);
        String[] argarray = new String[st.countTokens()];
        int ix = 0;
        while (ix < argarray.length && st.hasMoreTokens()) {
            argarray[ix] = st.nextToken();
            ++ix;
        }
        return argarray;
    }

    public String getTimeString() {
        NmxDateFormat dfmt = new NmxDateFormat();
        return dfmt.format(this.getMsgTimeSecs());
    }

    public String getMessage(String msgfmt) {
        if (msgfmt == null) {
            msgfmt = this.format;
        }
        int flength = msgfmt.length();
        String[] argarray = this.getArguments();
        StringBuffer outbuf = new StringBuffer(flength);
        int ix = 0;
        while (ix < flength) {
            char charix = msgfmt.charAt(ix);
            if (charix == '%' && ix + 1 < flength) {
                if ((charix = msgfmt.charAt(++ix)) == '%') {
                    outbuf.append(charix);
                } else if (charix == 'a') {
                    outbuf.append(this.arguments);
                } else if (charix == 'm') {
                    outbuf.append(this.classId);
                } else if (charix == 'p') {
                    outbuf.append(this.severity);
                } else if (charix == 'r') {
                    outbuf.append("\r\n");
                } else if (charix == 's') {
                    outbuf.append(this.sourceId);
                } else if (charix == 't') {
                    outbuf.append(this.getTimeString());
                } else if (charix >= '1' && charix <= '9') {
                    int index = charix - 49;
                    if (index < argarray.length) {
                        outbuf.append(argarray[index]);
                    } else {
                        outbuf.append('*');
                    }
                } else {
                    outbuf.append('*');
                }
            } else {
                outbuf.append(charix);
            }
            ++ix;
        }
        return outbuf.toString();
    }

    public String getMessage() {
        return this.getMessage(this.format);
    }

    public boolean isPing() {
        return this.classId.equalsIgnoreCase("ping");
    }

    public String toString() {
        return String.valueOf(this.sourceId) + ":" + this.classId;
    }

    public String toString(boolean complete) {
        if (complete) {
            return String.valueOf(this.sourceId) + ":" + this.classId + "@" + this.getTimeString();
        }
        return this.toString();
    }
}

