/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.alert;

import ca.nanometrics.alert.AlertHandler;
import ca.nanometrics.alert.AlertMessage;
import ca.nanometrics.alert.AlertReceiverConfig;
import ca.nanometrics.net.PersistentMulticastSocket;
import ca.nanometrics.packet.InternetPacketWrapper;
import ca.nanometrics.packet.PacketWrapper;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.util.Log;
import ca.nanometrics.util.NmxDateFormat;
import ca.nanometrics.util.Runner;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.Iterator;

public class AlertReceiver
extends Runner {
    static final int RX_BUFFER_SIZE = 1024;
    static final int WDG_LOOP_TIMEOUT = 60;
    static final long MILLIS_PER_DAY = 86400000L;
    private AlertReceiverConfig config;
    private AlertHandler handler;
    private MulticastSocket ds;
    private PacketWrapper pw = new InternetPacketWrapper();
    private String lastReportTime;
    private int rxCount;
    private NmxDateFormat dateFormat = new NmxDateFormat("yyyy/MM/dd_HH:mm:ss");

    public AlertReceiver(AlertReceiverConfig receiverConfig, AlertHandler alertHandler) throws IOException {
        this.config = receiverConfig;
        this.handler = alertHandler;
        this.resetStatus();
        try {
            this.ds = new PersistentMulticastSocket(this.config.getPort(), 30000);
            this.ds.setSoTimeout(500);
            this.joinMulticastGroups(this.config.getMcastGroups());
        }
        catch (IOException e) {
            Log.report(this, 1, 5, "Cannot open datagram socket.");
            throw e;
        }
    }

    private void joinGroup(String mcastGroup) {
        try {
            this.ds.joinGroup(InetAddress.getByName(mcastGroup));
            Log.report(this, 3, 2, "Receiving on multicast group " + mcastGroup);
        }
        catch (Exception exc) {
            Log.report(this, 4, 3, "Cannot join multicast group " + mcastGroup);
        }
    }

    private void joinMulticastGroups(Iterator groups) {
        while (groups.hasNext()) {
            String group = groups.next().toString();
            this.joinGroup(group);
        }
    }

    private void reportRxError(int errnum, DatagramPacket dp, byte[] wpkt) {
        Log.report(this, errnum, 2, "invalid packet type = " + this.pw.getDataType(wpkt) + ", len = " + dp.getLength() + ", datalen = " + this.pw.getDataLength(wpkt) + " from " + dp.getAddress().getHostAddress());
    }

    protected void handleAlertMessage(byte[] wpkt, DatagramPacket dp) {
        try {
            AlertMessage msg = new AlertMessage(wpkt, this.pw.getDataOffset(), this.pw.getDataLength(wpkt));
            ++this.rxCount;
            Log.report(this, 4, 0, "Received " + msg);
            this.handler.report(msg);
        }
        catch (InvalidInputException e) {
            Log.report(this, 5, 2, "Rx exception: " + e.getMessage());
        }
    }

    public void runbody() throws IOException {
        byte[] buffer = new byte[1024];
        DatagramPacket dp = new DatagramPacket(buffer, buffer.length);
        this.ds.receive(dp);
        byte[] wpkt = dp.getData();
        if (this.stayAlive && dp.getAddress() != null) {
            if (this.pw.isValidPacket(wpkt, dp.getLength())) {
                if (this.pw.getDataType(wpkt) == 320) {
                    this.handleAlertMessage(wpkt, dp);
                } else {
                    this.reportRxError(6, dp, wpkt);
                }
            } else {
                this.reportRxError(7, dp, wpkt);
            }
        }
    }

    public void run() {
        this.setPriority(10);
        Log.report(this, 2, 2, "starting with priority " + this.getPriority());
        while (this.stayAlive) {
            this.setWdgTimeout(60);
            try {
                this.runbody();
            }
            catch (InterruptedIOException interruptedIOException) {
            }
            catch (IOException e) {
                Log.report(this, 8, 3, e.getMessage());
            }
        }
        Log.report(this, 3, 1, "quitting...");
        this.reportStatus();
    }

    protected void reportStatus() {
        Log.report(this, 0, 2, "Messages recd since " + this.lastReportTime + ": " + this.rxCount);
    }

    public void reportStatus(String hint) {
        if (hint.equals("RX") || hint.equals("ALL") || hint.equals("SUMMARY")) {
            this.reportStatus();
        }
    }

    protected void resetStatus() {
        this.lastReportTime = this.dateFormat.format(System.currentTimeMillis() / 1000L);
        this.rxCount = 0;
    }

    public synchronized void reportSummary() {
        this.reportStatus();
        this.resetStatus();
    }
}

