/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.alert;

import ca.nanometrics.alert.AlertMessage;
import ca.nanometrics.alert.AlertSenderConfig;
import ca.nanometrics.alert.BufferedAlertHandler;
import ca.nanometrics.net.DatagramSender;
import ca.nanometrics.packet.InternetPacketWrapper;
import ca.nanometrics.packet.PacketWrapper;
import ca.nanometrics.util.Log;
import java.io.IOException;

public class AlertSender
extends BufferedAlertHandler {
    private DatagramSender ds = null;
    private PacketWrapper pw = new InternetPacketWrapper();
    private int msgSent = 0;

    public AlertSender(String host, int port, String sourceId) throws IOException {
        super("AlertSender", 500);
        this.setSourceId(sourceId);
        this.ds = host.equalsIgnoreCase("none") ? null : new DatagramSender(host, port);
    }

    public AlertSender(AlertSenderConfig config) throws IOException {
        this(config.getInetHost(), config.getInetPort(), config.getSourceId());
    }

    public void reportStatus() {
        Log.report(this, 0, 2, "messages sent: " + this.msgSent);
    }

    protected void open() {
        this.setPriority(8);
        Log.report(this, 5, 2, "starting with priority " + this.getPriority());
        if (this.ds != null) {
            Log.report(this, 5, 2, "forwarding alerts to " + this.ds.getAddress() + ":" + this.ds.getRemotePort());
        } else {
            Log.report(this, 5, 2, "alert forwarding is disabled");
        }
    }

    protected void close() {
        Log.report(this, 5, 2, "shutting down...");
    }

    protected void processAlert(AlertMessage msg) {
        if (this.ds != null) {
            if (!msg.isPing()) {
                Log.report(this, 1, 1, "sending " + msg);
            }
            try {
                this.ds.send(this.pw.makeWrappedPacket(msg));
                ++this.msgSent;
            }
            catch (IOException e) {
                Log.report(this, 2, 3, "Send failed: " + e.getMessage());
            }
        }
    }
}

