/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.alert;

import ca.nanometrics.alert.AlertHandler;
import ca.nanometrics.alert.AlertMessage;
import ca.nanometrics.util.BufferedConsumer;
import ca.nanometrics.util.Log;

public abstract class BufferedAlertHandler
extends BufferedConsumer
implements AlertHandler {
    private String sourceId = null;

    public BufferedAlertHandler(String name, int qlen) {
        super(name, qlen);
    }

    protected void setSourceId(String id) {
        this.sourceId = id;
    }

    public void report(String mSource, String mClass, int mSeverity, String mFormat, String mArgs) {
        this.report(new AlertMessage(mSource, mClass, mSeverity, mFormat, mArgs));
    }

    public void report(String mClass, int mSeverity, String mFormat, String mArgs) {
        this.report(this.sourceId, mClass, mSeverity, mFormat, mArgs);
    }

    public void report(AlertMessage alert) {
        if (alert != null) {
            if (!alert.isPing()) {
                Log.report(this, 0, 1, "enqueuing " + alert.getClassId() + " from " + alert.getSourceId());
            }
            this.append(alert);
        }
    }

    protected final void process(Object obj) {
        this.processAlert((AlertMessage)obj);
    }

    protected abstract void processAlert(AlertMessage var1);
}

