/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.bundle;

import ca.nanometrics.bundle.SohBundle;
import ca.nanometrics.util.Format;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.util.LittleEndian;

public class LibraGpsTimeQualityBundle
extends SohBundle {
    public static final int BUNDLE_TYPE = 54;
    static final int OFFSET_TO_STATUS = 5;
    static final int OFFSET_TO_NSAT = 7;
    static final int OFFSET_TO_PDOP = 9;
    static final int OFFSET_TO_TDOP = 13;
    static final String[] gpsStatus = new String[]{"DOING_FIXES", "NO_TIME", "NEED_INIT", "PDOP_TOO_HIGH", "ACQUIRE_SATS"};
    private static final int NUMBER_OF_COLUMNS = 6;
    public static final int TIME_IN_SECONDS_COL = 0;
    public static final int FORMATTED_TIME_COL = 1;
    public static final int GPS_STATUS_COL = 2;
    public static final int NUM_SATS_COL = 3;
    public static final int PDOP_COL = 4;
    public static final int TDOP_COL = 5;

    public LibraGpsTimeQualityBundle() {
        super(54);
    }

    public LibraGpsTimeQualityBundle(byte[] buffer, int index) {
        super(buffer, index, 54);
    }

    public LibraGpsTimeQualityBundle(SohBundle rhs) throws InvalidInputException {
        super(rhs, 54);
    }

    public SohBundle createBundle() {
        return new LibraGpsTimeQualityBundle();
    }

    public int getGpsStatusVal() {
        return LittleEndian.readShort(this.guts, 5);
    }

    public String getGpsStatus() {
        int status = this.getGpsStatusVal();
        if (status >= 0 && status < 5) {
            return gpsStatus[status];
        }
        return gpsStatus[4];
    }

    public float getPDop() {
        return LittleEndian.readFloat(this.guts, 9);
    }

    public float getTDop() {
        return LittleEndian.readFloat(this.guts, 13);
    }

    public int getNumSats() {
        return LittleEndian.readShort(this.guts, 7);
    }

    public SohBundle createBundle(byte[] bytes, int index) {
        return new LibraGpsTimeQualityBundle(bytes, index);
    }

    public String getCsvName() {
        return "lgq";
    }

    public String getCsvTitle() {
        return "VSat: Libra GPS Time Quality for Instrument";
    }

    public String getCsvData() {
        StringBuffer sb = new StringBuffer(this.getCsvDateString());
        Format f = new Format("%12d");
        sb.append("," + f.form(this.getGpsStatusVal()));
        sb.append("," + f.form(this.getNumSats()));
        f = new Format("%12.6f");
        sb.append("," + f.form(this.getPDop()));
        sb.append("," + f.form(this.getTDop()));
        return sb.toString();
    }

    public int getPrecisionByIndex(int index) {
        switch (index) {
            case 0: {
                return 0;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 0;
            }
            case 4: {
                return 6;
            }
            case 5: {
                return 6;
            }
        }
        return 0;
    }

    public Object getReadingByIndex(int index) {
        switch (index) {
            case 0: {
                return new Long(this.getLongSeconds());
            }
            case 1: {
                return csvDateFormat.format(this.getLongSeconds());
            }
            case 2: {
                return new Integer(this.getGpsStatusVal());
            }
            case 3: {
                return new Integer(this.getNumSats());
            }
            case 4: {
                return new Double(this.getPDop());
            }
            case 5: {
                return new Double(this.getTDop());
            }
        }
        return null;
    }

    public String getDataTypeByIndex(int index) {
        switch (index) {
            case 0: {
                return "time";
            }
            case 1: {
                return "formattedTime";
            }
            case 2: {
                return "integer";
            }
            case 3: {
                return "integer";
            }
            case 4: {
                return "double";
            }
            case 5: {
                return "double";
            }
        }
        return "";
    }

    public String getReadingHeaderByIndex(int index) {
        switch (index) {
            case 0: {
                return "Time(longsecs)";
            }
            case 1: {
                return " Time(date-time)";
            }
            case 2: {
                return " GPSstatus";
            }
            case 3: {
                return " UsableSatellites";
            }
            case 4: {
                return " PDOP";
            }
            case 5: {
                return " TDOP";
            }
        }
        return "";
    }

    public int getColumnCount() {
        return 6;
    }

    public String getName() {
        return "Libra GPS Time Quality";
    }
}

