/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.bundle;

import ca.nanometrics.bundle.SlotBundle;
import ca.nanometrics.bundle.SohBundle;
import ca.nanometrics.util.Format;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.util.LittleEndian;

public class NmxBusMasterBundle
extends SlotBundle {
    public static final int BUNDLE_TYPE = 63;
    static final int OFFSET_TO_REQUESTERID = 5;
    static final int OFFSET_TO_REQUESTS = 7;
    static final int OFFSET_TO_PERMITS = 10;
    static final int OFFSET_TO_DENIALS = 13;
    static final int OFFSET_TO_SPARE = 16;
    private static final int NUMBER_OF_COLUMNS = 6;
    public static final int TIME_IN_SECONDS_COL = 0;
    public static final int FORMATTED_TIME_COL = 1;
    public static final int INST_ID_COL = 2;
    public static final int NUM_REQUESTS_REC_COL = 3;
    public static final int NUM_PERMITS_ISSUED_COL = 4;
    public static final int NUM_DENIALS_ISSUED_COL = 5;

    public NmxBusMasterBundle() {
        super(63);
    }

    public NmxBusMasterBundle(byte[] buffer, int index) {
        super(buffer, index, 63);
    }

    public NmxBusMasterBundle(SohBundle bundle) throws InvalidInputException {
        super(bundle, 63);
    }

    public int getSlotId() {
        return LittleEndian.readUShort(this.guts, 5);
    }

    public String getRequesterName() {
        return this.getSlotIdName(this.getSlotId());
    }

    public int getRequestCount() {
        return LittleEndian.readUInt24(this.guts, 7);
    }

    public int getPermitCount() {
        return LittleEndian.readUInt24(this.guts, 10);
    }

    public int getDenialCount() {
        return LittleEndian.readUInt24(this.guts, 13);
    }

    public SohBundle createBundle(byte[] bytes, int index) {
        return new NmxBusMasterBundle(bytes, index);
    }

    public String getCsvName() {
        return "nbs";
    }

    public String getCsvTitle() {
        return "NMXbus Master";
    }

    public String getCsvData() {
        StringBuffer sb = new StringBuffer(this.getCsvDateString());
        Format f = new Format("%6s");
        sb.append("," + f.form(this.getRequesterName()));
        f = new Format("%12d");
        sb.append("," + f.form(this.getRequestCount()));
        sb.append("," + f.form(this.getPermitCount()));
        sb.append("," + f.form(this.getDenialCount()));
        return sb.toString();
    }

    public Object getReadingByIndex(int index) {
        switch (index) {
            case 0: {
                return new Long(this.getLongSeconds());
            }
            case 1: {
                return csvDateFormat.format(this.getLongSeconds());
            }
            case 2: {
                return this.getRequesterName();
            }
            case 3: {
                return new Integer(this.getRequestCount());
            }
            case 4: {
                return new Integer(this.getPermitCount());
            }
            case 5: {
                return new Integer(this.getDenialCount());
            }
        }
        return null;
    }

    public String getDataTypeByIndex(int index) {
        switch (index) {
            case 0: {
                return "time";
            }
            case 1: {
                return "formattedTime";
            }
            case 2: {
                return "string";
            }
            case 3: {
                return "integer";
            }
            case 4: {
                return "integer";
            }
            case 5: {
                return "integer";
            }
        }
        return "";
    }

    public int getPrecisionByIndex(int index) {
        switch (index) {
            case 0: {
                return 0;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 0;
            }
            case 4: {
                return 0;
            }
            case 5: {
                return 0;
            }
        }
        return 0;
    }

    public String getReadingHeaderByIndex(int index) {
        switch (index) {
            case 0: {
                return "Time(longsecs)";
            }
            case 1: {
                return " Time(date-time)";
            }
            case 2: {
                return " Instrument ID";
            }
            case 3: {
                return " #Requests Rec";
            }
            case 4: {
                return " #Permits Issued";
            }
            case 5: {
                return " #Denials Issued";
            }
        }
        return "";
    }

    public boolean isColorColumn(int index) {
        return false;
    }

    public int getColumnCount() {
        return 6;
    }

    public String getName() {
        return "NMX bus Master";
    }
}

